<title><?php echo e(trans('home.paymentMethods')); ?></title>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.paymentMethods')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.paymentMethods')); ?></li>
            </ol>
        </div>

        <div class="btn btn-list">
            <a href="<?php echo e(url('admin/payment-methods/create')); ?>"><button class="btn ripple btn-primary"><i
                        class="fas fa-plus-circle"></i> <?php echo e(trans('home.add')); ?></button></a>
            <a id="btn_active"><button class="btn ripple btn-dark"><i class="fas fa-eye"></i>
                    <?php echo e(trans('home.publish/unpublish')); ?></button></a>
            <a id="btn_delete"><button class="btn ripple btn-danger"><i class="fas fa-trash"></i>
                    <?php echo e(trans('home.delete')); ?></button></a>
        </div>
    </div>
    <!-- End Page Header -->

    <?php if(session()->has('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session()->pull('success')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.paymentMethods')); ?></h6>
                        <p class="text-muted card-sub-title">
                            <?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                    </div>

                    <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll" /></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.name_en')); ?></th>
                                    <th class="wd-25p"><?php echo e(trans('home.name_ar')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.logo')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.fees')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr id="<?php echo e($paymentMethod->id); ?>">
                                    <td> <input type="checkbox" name="checkbox"
                                            class="tableChecked" value="<?php echo e($paymentMethod->id); ?>" /> </td>
                                    <td><a
                                            href="<?php echo e(route('payment-methods.edit', $paymentMethod->id)); ?>"><?php echo e($paymentMethod->id); ?></a>
                                    </td>
                                    <td><a
                                            href="<?php echo e(route('payment-methods.edit', $paymentMethod->id)); ?>"><?php echo e($paymentMethod->name_en); ?></a>
                                    </td>
                                    <td><a
                                            href="<?php echo e(route('payment-methods.edit', $paymentMethod->id)); ?>"><?php echo e($paymentMethod->name_ar); ?></a>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('payment-methods.edit', $paymentMethod->id)); ?>">

                                            <div class="col-md-6">
                                                <img src="<?php echo e($paymentMethod->image_source); ?>" width="150">
                                            </div>
                                        </a>
                                    </td>
                                    <td><a
                                            href="<?php echo e(route('payment-methods.edit', $paymentMethod->id)); ?>"><?php echo e($paymentMethod->fees); ?></a>
                                    </td>
                                    <td><a href="<?php echo e(route('payment-methods.edit', $paymentMethod->id)); ?>"><?php if($paymentMethod->status
                                            == 1): ?> <?php echo e(trans('home.yes')); ?> <?php else: ?> <?php echo e(trans('home.no')); ?> <?php endif; ?></a></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- End Row -->
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/paymentMethods/paymentMethods.blade.php ENDPATH**/ ?>