<title><?php echo e(trans('home.edit_attribute')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.attributes')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/attributes')); ?>"><?php echo e(trans('home.attributes')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_attribute')); ?></li>
            </ol>
        </div>
    </div>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.edit_attribute')); ?></h6>
                    </div>
                    <?php echo Form::model($attribute, ['route' => ['attributes.update', $attribute->id], 'method' => 'PUT', 'data-toggle'=>'validator', 'files'=>'true']); ?>


                    <div class="border">
                        <div class="bg-light">
                            <nav class="nav nav-tabs">
                                <a class="nav-link active" data-toggle="tab" href="#tab1"><?php echo e(trans('home.attribute')); ?></a>
                                <a class="nav-link" data-toggle="tab" href="#tab2"><?php echo e(trans('home.values')); ?></a>
                            </nav>
                        </div>

                        <div class="card-body tab-content">
                            <!-- Tab 1: Attribute Details -->
                            <div class="tab-pane active show" id="tab1">
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label><?php echo e(trans('home.name_en')); ?></label>
                                        <input class="form-control" name="name_en" type="text"
                                            value="<?php echo e($attribute->name_en); ?>" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label><?php echo e(trans('home.name_ar')); ?></label>
                                        <input class="form-control" name="name_ar" type="text"
                                            value="<?php echo e($attribute->name_ar); ?>" placeholder="<?php echo e(trans('home.name_ar')); ?>">
                                    </div>

                                    <div class="form-group col-md-12">
                                        <label class="ckbox">
                                            <input name="status" value="1" type="checkbox" <?php echo e($attribute->status ? 'checked' : ''); ?>><span
                                                class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <!-- Tab 2: Attribute Values -->
                            <div class="tab-pane" id="tab2">
                                <div class="field_wrapper">
                                   <?php $__currentLoopData = $attribute->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row">
                                                    <div class="form-group col-md-4">
                                                        <label><?php echo e(trans('home.value_en')); ?></label>
                                                        <input type="hidden" name="values[<?php echo e($index); ?>][id]" value="<?php echo e($value->id); ?>">
                                                        <input type="text" class="form-control"
                                                            value="<?php echo e($value->value_en); ?>"
                                                            name="values[<?php echo e($index); ?>][value_en]"
                                                            placeholder="<?php echo e(trans('home.value_en')); ?>">
                                                    </div>

                                                    <div class="form-group col-md-4">
                                                        <label><?php echo e(trans('home.value_ar')); ?></label>
                                                        <input type="text" class="form-control"
                                                            value="<?php echo e($value->value_ar); ?>"
                                                            name="values[<?php echo e($index); ?>][value_ar]"
                                                            placeholder="<?php echo e(trans('home.value_ar')); ?>">
                                                    </div>

                                                    <div class="form-group col-md-2">
                                                        <label><?php echo e(trans('home.code')); ?></label>
                                                        <input type="color" class="form-control"
                                                            value="<?php echo e($value->code); ?>"
                                                            name="values[<?php echo e($index); ?>][code]">
                                                    </div>

                                                    <div class="form-group col-md-2">
                                                        <a href="javascript:void(0);" class="remove_button btn">
                                                            <i class="fas fa-trash-alt"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>

                                <a href="javascript:void(0);" class="add_button btn" title="Add field">
                                    <i class="fas fa-plus-square"></i>
                                </a>
                            </div>
                        </div>

                        <div class="form-group col-md-12 mt-3">
                            <button type="submit" class="btn btn-success"><?php echo e(trans('home.save')); ?></button>
                            <a href="<?php echo e(url('/admin/attributes')); ?>">
                                <button type="button" class="btn btn-danger mr-1"><?php echo e(trans('home.cancel')); ?></button>
                            </a>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    $(document).ready(function(){
        var maxField = 100;
        var addButton = $('.add_button');
        var wrapper = $('.field_wrapper');
        var x = $('.field_wrapper .row').length;

        function getFieldHTML(index) {
            return `
            <div class="row">
                <div class="form-group col-md-4">
                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.value_en')); ?>" name="values[${index}][value_en]">
                </div>
                <div class="form-group col-md-4">
                    <input type="text" class="form-control" placeholder="<?php echo e(trans('home.value_ar')); ?>" name="values[${index}][value_ar]">
                </div>
                <div class="form-group col-md-2">
                    <input type="color" class="form-control" name="values[${index}][code]">
                </div>
                <div class="form-group col-md-2">
                    <a href="javascript:void(0);" class="remove_button btn"><i class="fas fa-trash-alt"></i></a>
                </div>
            </div>`;
        }

        $(addButton).click(function(){
            if(x < maxField){
                x++;
                $(wrapper).append(getFieldHTML(x));
            }
        });

        $(wrapper).on('click', '.remove_button', function(e){
            e.preventDefault();
            $(this).closest('.row').remove();
            x--;
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/attributes/editAttribute.blade.php ENDPATH**/ ?>