<?php $__env->startSection('meta'); ?>
<title>
    <?php echo e(__('home.sample_request_checkout')); ?>

</title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- page-title -->
<?php echo $__env->make('website._breadcrumb', ['page_title' => __('home.sample_request_checkout')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- /page-title -->

<!-- page-cart -->
<section class="flat-spacing-11">
    <div class="container">
        <div class="tf-page-cart-wrap layout-2">
            <div class="tf-page-cart-item">
                <h5 class="fw-5 mb_20"><?php echo e(__('home.Billing details')); ?></h5>
                <form action="<?php echo e(route('sample.request.place.order')); ?>" method="POST" class="form-checkout">
                    <?php echo csrf_field(); ?>
                    <div class="box grid-2">
                        <fieldset class="fieldset">
                            <label for="first-name"><?php echo e(__('home.f_name')); ?></label>
                            <input type="text" id="first-name" placeholder="<?php echo e(__('home.f_name')); ?>" value="<?php echo e(auth()->user()->f_name ?? old('f_name')); ?>" name='f_name' required>
                        </fieldset>
                        <fieldset class="fieldset">
                            <label for="last-name"><?php echo e(__('home.l_name')); ?></label>
                            <input type="text" id="last-name" placeholder="<?php echo e(__('home.l_name')); ?>" value="<?php echo e(auth()->user()->l_name ?? old('l_name')); ?>" name='l_name' required>
                        </fieldset>
                    </div>

                    <div class="box grid-2">
                        <fieldset class="box fieldset">
                            <label for="phone"><?php echo e(__('home.Phone Number')); ?></label>
                            <input type="number" id="phone" placeholder="<?php echo e(__('Enter phone number')); ?>" name="phone" value="<?php echo e(old('phone')); ?>" required>
                        </fieldset>
                        <fieldset class="box fieldset">
                            <label for="email"><?php echo e(__('home.Email')); ?></label>
                            <input type="email" id="email" placeholder="<?php echo e(__('Enter email')); ?>" name="email" value="<?php echo e(old('email')); ?>">
                        </fieldset>
                    </div>

                    <fieldset class="box fieldset">
                        <label for="country"><?php echo e(__('home.country')); ?></label>
                        <div class="select-custom">
                            <select class="tf-select w-100" id="country" name="country_id" required data-default="">
                                <option value="null"><?php echo e(__('home.select_country')); ?></option>
                                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($country->id); ?>" selected><?php echo e($country->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </fieldset>

                    <div class="box grid-2">
                        <fieldset>
                            <label for="governorates"><?php echo e(__('home.governorates')); ?></label>
                            <div class="select-custom">
                                <select class="tf-select w-100 governorate" id="governorates" name="governorate_id" required data-default="">
                                    <option value="null"><?php echo e(__('home.select_governorate')); ?></option>
                                    <?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $governorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($governorate->id); ?>"><?php echo e($governorate->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="city"><?php echo e(__('home.Town/City')); ?></label>
                            <input type="text" id="city" placeholder="<?php echo e(__('home.Town/City')); ?>" name="city" value="<?php echo e(old('city')); ?>" required>
                        </fieldset>
                    </div>



                    <fieldset class="box fieldset">
                        <label for="address"><?php echo e(__('home.Address')); ?></label>
                        <input type="text" id="address" placeholder="<?php echo e(__('home.Address')); ?>" name="address" value="<?php echo e(old('address')); ?>" required>
                    </fieldset>

                    <fieldset class="box fieldset">
                        <label for="note"><?php echo e(__('home.Order notes (optional)')); ?></label>
                        <textarea name="note" id="note"><?php echo e(old('note')); ?></textarea>
                    </fieldset>

               
            </div>
            <div class="tf-page-cart-footer">
                <div class="tf-cart-footer-inner">
                    <h5 class="fw-5 mb_20"><?php echo e(__('home.sample_request_items')); ?></h5>
                    <div class="tf-page-cart-checkout widget-wrap-checkout">
                        <ul class="wrap-checkout-product">
                            <?php $__currentLoopData = $sampleRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sampleRequest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="checkout-product-item">
                                <figure class="img-product">
                                    <?php if($sampleRequest->product_variant_id): ?>
                                    <img src="<?php echo e($sampleRequest->variant->first_image); ?>" alt="<?php echo e($sampleRequest->product->name); ?>">
                                    <?php else: ?>

                                    <img src="<?php echo e($sampleRequest->product->main_image_path); ?>" alt="<?php echo e($sampleRequest->product->name); ?>">
                                    <?php endif; ?>
                                   
                                </figure>
                                <div class="content">
                                    <div class="info">
                                    <p class="name"><?php echo e($sampleRequest->product->name); ?></p>
                                    <?php if($sampleRequest->variant): ?>

                                        <?php $__currentLoopData = $sampleRequest->variant->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <p><strong><?php echo e($value->value->attribute->name); ?></strong>: <?php echo e($value->value->value); ?></p>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                    </div>
                               
                                </div>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    
                        <div class="d-flex justify-content-between line pb_20">
                            <h6 class="fw-5"><?php echo e(__('home.shipping')); ?></h6>
                           
                            <h6 class="simple-request-shipping-fees fw-5"> <?php echo e(config('app.currency')); ?> <?php echo e(config('site_standard_shipping_fees')); ?></h6>
                            

                        </div>

                        <div class="wd-check-payment">
                            <?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="fieldset-radio mb_20">
                                <input type="radio" name="payment_method_id" value="<?php echo e($paymentMethod->id); ?>" id="payment_method_<?php echo e($paymentMethod->id); ?>" class="tf-check" checked>
                                <label for="payment_method_<?php echo e($paymentMethod->id); ?>"><?php echo e($paymentMethod->name); ?></label>

                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                           
                        </div>
                        <button type="submit" class="tf-btn radius-3 btn-fill btn-icon animate-hover-btn justify-content-center"><?php echo e(__('home.place_order')); ?></button>
                    </div>
                </div>
            </div>

        </form>
        </div>
    </div>
</section>
<!-- page-cart -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<?php if($errors->any()): ?>
<script>
    toastr.options = {
        "closeButton": true
        , "progressBar": true
        , "positionClass": "toast-top-right"
    };
    <?php $__currentLoopData = $errors -> all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    toastr.error("<?php echo e($error); ?>");
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</script>

<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/sample-request-checkout.blade.php ENDPATH**/ ?>