<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.edit_configration')); ?> <?php echo e(trans("home.$lang")); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.edit_configration')); ?> <?php echo e(trans("home.$lang")); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_configration')); ?> <?php echo e(trans("home.$lang")); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_configration')); ?> <?php echo e(trans("home.$lang")); ?></h6>
                        </div>
                        <form action="<?php echo e(route('configrations.update',$lang)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PATCH'); ?>
                           
                            <div class="row">
                                <div class="form-group col-md-12 ">
                                    <fieldset class="form-group">
                                        <label for="title_en"><?php echo e(__('home.app_name')); ?></label>
                                        <input type="text" class="form-control"  name="app_name" value="<?php echo e($configrations['app_name']); ?>">
                                    </fieldset>
                                </div>
    
    
                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(__('home.top_text')); ?></label>
                                    <textarea class="form-control" id="myeditorinstance" name="top_text" type="text" ><?php echo $configrations['top_text']; ?></textarea>
                                </div>

                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(__('home.site_description')); ?></label>
                                    <textarea class="form-control" id="myeditorinstance" name="site_description" type="text" ><?php echo $configrations['site_description']; ?></textarea>
                                </div>
    
                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(__('home.footer_text')); ?></label>
                                    <textarea class="form-control" id="myeditorinstance" name="footer_text" type="text" ><?php echo $configrations['footer_text']; ?></textarea>
                                </div>
    
    
    
                                <div class="form-group col-md-4">
                                    <label><?php echo e(trans('home.app_logo')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="logo">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-4">
                                    <label><?php echo e(trans('home.app_footer_logo')); ?></label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="footer_logo">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-4">
                                    <label>favicon</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="favicon">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>

                             
                                <div class="form-group col-md-4">
                                    <img src="<?php echo e($configrations['logo']); ?>" width="150">
                                </div>



                                <div class="form-group col-md-4">
                                    <img src="<?php echo e($configrations['footer_logo']); ?>" width="150">
                                </div>

                                <div class="form-group col-md-4">
                                    <img src="<?php echo e($configrations['favicon']); ?>" width="150">
                                </div>

                            

    
                                <div class="form-group col-md-12">
                                    <label class=""><?php echo e(__('home.copyright')); ?></label>
                                    <textarea class="form-control"  name="copyright" type="text" ><?php echo $configrations['copyright']; ?></textarea>
                                </div>
    
    
    
                                <div class="form-group col-md-12 mt-3">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                        <?php echo e(__('home.update')); ?> </button>
                                    <a href="<?php echo e(route('configrations.edit','ar')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                            <?php echo e(__('home.cancel')); ?></button></a>
                                </div>
    
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/configrations/configration.blade.php ENDPATH**/ ?>