<?php $__env->startSection('meta'); ?>
<?php echo $metatags ?>
<?php echo $schema ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center"><?php echo e(__('home.products')); ?></div>
        
    </div>
</div>
<!-- /page-title -->
<!-- Section Product -->
<section class="flat-spacing-2">
    <div class="container">
        <form action="<?php echo e(LaravelLocalization::LocalizeUrl('products')); ?>" method="GET" id="facet-filter-form"
            class="facet-filter-form">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-3">
                    <div class="canvas-wrapper">
                        <header class="canvas-header">
                            <div class="tf-btn-filter">
                                <span class="icon icon-filter"></span>
                                <span><?php echo e(__('home.filter')); ?></span>
                            </div>
                        </header>
                        <div class="tf-shop-sidebar wrap-sidebar-mobile">

                            <!-- filter-by-attributes -->

                            <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="widget-facet">
                                <div class="facet-title" data-bs-target="#attribute-<?php echo e($key); ?>" data-bs-toggle="collapse"
                                    aria-expanded="true" aria-controls="attribute-<?php echo e($key); ?>">
                                    <span><?php echo e($attribute->name); ?></span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>

                                <div id="attribute-<?php echo e($key); ?>" class="collapse show">
                                    <ul class="tf-filter-group current-scrollbar mb_36">
                                        <?php $__currentLoopData = $attribute->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attributeValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                        <li class="list-item d-flex gap-12 align-items-center">
                                            <input type="checkbox" name="filter_attributeValues[<?php echo e($attribute->id); ?>][]"
                                                value="<?php echo e($attributeValue->id); ?>" class="tf-check"
                                                id="attribute-value-<?php echo e($attributeValue->id); ?>" <?php echo e(isset(request('filter_attributeValues')[$attribute->id]) &&
                                            in_array($attributeValue->id,
                                            request('filter_attributeValues')[$attribute->id]) ? 'checked' : ''); ?>>
                                            <label for="attribute-value-<?php echo e($attributeValue->id); ?>" class="label">
                                                <span><?php echo e($attributeValue->value); ?></span>&nbsp;<span>(<?php echo e($attributeValue->attribute->products->count()); ?>)</span>
                                            </label>
                                        </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>

                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <!-- /end-filter-by-attributes -->

                            <!-- filter-by-range-price -->

                            <div class="widget-facet">
                                <div class="facet-title" data-bs-target="#price" data-bs-toggle="collapse"
                                    aria-expanded="true" aria-controls="price">
                                    <span><?php echo e(__('home.price')); ?></span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="price" class="collapse show">
                                    <div class="widget-price filter-price">
                                        <div class="tow-bar-block">
                                            <div class="progress-price"></div>
                                        </div>
                                        <div class="range-input">
                                            <input class="range-min" type="range" min="<?php echo e($minPriceProduct); ?>"
                                                max="<?php echo e($maxPriceProduct); ?>" name="min_range"
                                                value="<?php echo e(request('min_range', $minPriceProduct)); ?>" />
                                            <input class="range-max" type="range" min="<?php echo e($minPriceProduct); ?>"
                                                max="<?php echo e($maxPriceProduct); ?>" name="max_range"
                                                value="<?php echo e(request('max_range', $maxPriceProduct)); ?>" />
                                        </div>
                                        <div class="box-title-price">
                                            <span class="title-price"><?php echo e(__('home.price')); ?> :</span>
                                            <div class="caption-price">
                                                <div>
                                                    <span><?php echo e(__('home.EGP')); ?></span>
                                                    <span class="min-price"><?php echo e(request('min_range', $minPriceProduct)); ?></span>
                                                </div>
                                                <span>-</span>
                                                <div>
                                                    <span><?php echo e(__('home.EGP')); ?></span>
                                                    <span class="max-price"><?php echo e(request('max_range', $maxPriceProduct)); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <!-- /end-filter-by-range-price -->

                        </div>

                    </div>
                </div>
                <div class="col-sm-12 col-md-12 col-lg-9">
                    <div class="tf-shop-control grid-1 align-items-center">
                        <div class="tf-control-sorting d-flex justify-content-end">
                            <div class="tf-dropdown">
                                <select class="btn-select form-select" name="sort_by" id="sortOptions">
                                    <option value="date-new-to-old" <?php echo e(request('sort_by')=='date-new-to-old'
                                        ? 'selected' : ''); ?>><?php echo e(__('home.Date, new to old')); ?></option>
                                    <option value="featured" <?php echo e(request('sort_by')=='featured' ? 'selected' : ''); ?>>
                                        Featured</option>
                                    <option value="price-low-to-high" <?php echo e(request('sort_by')=='price-low-to-high'
                                        ? 'selected' : ''); ?>><?php echo e(__('home.Price, low to high')); ?></option>
                                    <option value="price-high-to-low" <?php echo e(request('sort_by')=='price-high-to-low'
                                        ? 'selected' : ''); ?>><?php echo e(__('home.Price, high to low')); ?></option>
                                    <option value="date-old-to-new" <?php echo e(request('sort_by')=='date-old-to-new'
                                        ? 'selected' : ''); ?>><?php echo e(__('home.Date, old to new')); ?></option>

                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="wrapper-control-shop">
                        <div class="meta-filter-shop"></div>
                        <div class="grid-layout wrapper-shop" data-grid="grid-3">
                            <!-- card product  -->
                            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="card-product" data-brand="brand-<?php echo e($key); ?>"
                                data-price="<?php echo e($product->productStock->price); ?>">
                                <div class="card-product-wrapper">
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('product/'.$product->link)); ?>"
                                        class="product-img">
                                        <img class="lazyload img-product" data-src="<?php echo e($product->main_image_source); ?>"
                                            src="<?php echo e($product->main_image_source); ?>"
                                            alt="<?php echo e($product->alt_main_image); ?>">
                                        <?php if($product->second_image_source): ?>
                                        <img class="lazyload img-hover" data-src="<?php echo e($product->second_image_source); ?>"
                                            src="<?php echo e($product->second_image_source); ?>"
                                            alt="<?php echo e($product->second_image_source); ?>">
                                        <?php endif; ?>

                                    </a>

                                    <?php if(!$product->in_stock): ?>
                                    <span class="alarm"><?php echo e(__('home.out of stock')); ?></span>
                                    <?php endif; ?>

                                    <div class="list-product-btn column-left">
                                        <a href="javascript:void(0);"
                                            class="box-icon wishlist bg_white btn-icon-action">
                                            <span class="icon icon-heart add-wishList-item"
                                                data-product_id="<?php echo e($product->id); ?>"></span>
                                            <span class="tooltip"><?php echo e(__('home.add to wishlist')); ?></span>
                                            <span class="icon icon-delete remove-wishList-item"
                                                data-product_id="<?php echo e($product->id); ?>"></span>
                                        </a>

                                    </div>
                                    <div class="list-product-btn absolute-3">
                                        <a data-product_id="<?php echo e($product->id); ?>" class="box-icon quick-view style-2">
                                            <span class="icon icon-view"></span>
                                            <span class="text"><?php echo e(__('home.Quick View')); ?></span>
                                        </a>

                                        <a data-product_id="<?php echo e($product->id); ?>"
                                            class="box-icon btn-add-to-cart style-2 <?php echo e($product->in_stock ? '' : 'disabled-link'); ?>"
                                            <?php echo e($product->in_stock ? '' : 'aria-disabled=true'); ?>>
                                            <span class="icon icon-bag"></span>
                                            <span class="text"> <?php echo e($product->in_stock ? __('home.Add to Cart') : 'Sold
                                                Out'); ?></span>
                                        </a>

                                    </div>
                                    <!-- Discount percentage -->
                                    <?php if($product->discount): ?>
                                    <div class="on-sale-wrap text-end">
                                        <div class="on-sale-item"><?php echo e($product->productStock?->discount_percentage); ?>%
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>

                                <div class="card-product-info">
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('product/'.$product->link)); ?>"
                                        class="title link"><?php echo e($product->name); ?></a>
                                    <div class="product-prices d-flex justify-content-start">
                                        <?php if($product->discount): ?>
                                        <!-- Original price -->
                                        <span class="compare-at-price"><del><?php echo e($product->productStock?->price); ?> <?php echo e($product->productStock?->currency); ?></del></span>
                                        <!-- price after discount Original price -->
                                        <span class="price"><?php echo e($product->productStock->net_price); ?> <?php echo e($product->currency); ?></span>


                                        <?php else: ?>
                                        <span class="price"><?php echo e($product->productStock->price); ?> <?php echo e($product->currency); ?></span>
                                        <?php endif; ?>
                                    </div>


                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="alert alert-primary" role="alert">
                                no products avalibale
                            </div>
                            <?php endif; ?>


                        </div>
                        <?php if(count($products) > 0): ?>
                        <!-- Pagination -->
                        <ul class="tf-pagination-wrap tf-pagination-list tf-pagination-btn">
                            <!-- Previous Page -->
                            <?php if($products->onFirstPage()): ?>
                            <li>
                                <a href="javascript:void(0)" class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-left"></span>
                                </a>
                            </li>
                            <?php else: ?>
                            <li>
                                <a href="<?php echo e($products->appends(request()->except('page'))->previousPageUrl()); ?>"
                                    class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-left"></span>
                                </a>
                            </li>
                            <?php endif; ?>

                            <!-- Pagination Links -->
                            <?php if($products->hasPages()): ?>
                            <?php $__currentLoopData = $products->getUrlRange(1, $products->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="<?php echo e($page == $products->currentPage() ? 'active' : ''); ?>">
                                <a href="<?php echo e($url . '&' . http_build_query(request()->except('page'))); ?>"
                                    class="pagination-link animate-hover-btn">
                                    <?php echo e($page); ?>

                                </a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            <!-- Next Page -->
                            <?php if($products->hasMorePages()): ?>
                            <li>
                                <a href="<?php echo e($products->appends(request()->except('page'))->nextPageUrl()); ?>"
                                    class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-right"></span>
                                </a>
                            </li>
                            <?php else: ?>
                            <li>
                                <a href="javascript:void(0)" class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-right"></span>
                                </a>
                            </li>
                            <?php endif; ?>
                        </ul>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
<div class="btn-sidebar-style2">
    <button data-bs-toggle="offcanvas" data-bs-target="#sidebarmobile" aria-controls="offcanvas"><?php echo e(__('home.filter')); ?> <span class="icon icon-filter"></span></button>
</div>
<!-- /Section Product -->
    <!-- Filter sidebar-->
    <div class="offcanvas offcanvas-start canvas-filter canvas-sidebar" id="sidebarmobile">
    <form action="<?php echo e(LaravelLocalization::LocalizeUrl('products')); ?>" method="GET" id="facet-filter-form"
    class="facet-filter-form">
        <div class="canvas-wrapper">
            <header class="canvas-header">
                <span class="title"><?php echo e(__('home.filter')); ?></span>
                <span class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></span>
            </header>
            <div class="canvas-body sidebar-mobile-append">
            
            </div>
            
        </div>   
    </form>    
    </div>
    <!-- End Filter sidebar -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
<script>
    // Select all checkboxes or radio buttons within the form
    const form = document.getElementById('facet-filter-form');


    $(document).ready(function() {
        $("form").on("change", "input:checkbox", function() {
            form.submit();
        });
    });



    document.querySelector('select[name="sort_by"]').addEventListener('change', function() {
        form.submit();
    });

</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const minRangeInput = document.querySelector('.range-min');
        const maxRangeInput = document.querySelector('.range-max');
        const form = document.getElementById('facet-filter-form');

        function updatePriceAndSubmit() {
            if (parseInt(minRangeInput.value) <= parseInt(maxRangeInput.value)) {
                form.submit();
            } else {
                alert('Minimum price should not exceed maximum price.');
            }
        }

        minRangeInput.addEventListener('change', updatePriceAndSubmit);
        maxRangeInput.addEventListener('change', updatePriceAndSubmit);
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/products.blade.php ENDPATH**/ ?>