<title><?php echo e(trans('home.add_menu')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.menus')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/menus')); ?>"><?php echo e(trans('home.menus')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_menu')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.add_menu')); ?></h6>
                        </div>
                        <?php echo Form::open(['route' => 'menus.store', 'data-toggle'=>'validator', 'files'=>'true']); ?>

                            <div class="row">
                                <input type="hidden" name="type" value="main">
                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                    <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>" value="<?php echo e(old('name_en')); ?>" required>
                                </div>

                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>"  value="<?php echo e(old('name_ar')); ?>">
                                </div>

                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.order')); ?></label>
                                    <input class="form-control" name="order" type="number" placeholder="<?php echo e(trans('home.order')); ?>"  value="<?php echo e(old('order')); ?>">
                                </div>

                                <div class="form-group col-md-4">
                                    <label for="parent"><?php echo e(trans('home.parent')); ?></label>
                                    <select class="form-control select2" name="parent_id">
                                    <option disabled><?php echo e(trans('home.no_parent')); ?></option>
                                    <option value="null" <?php echo e(!old('parent_id') ? 'selected' : ''); ?>><?php echo e(trans('home.no_parent')); ?></option>
                                        <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($menu->id); ?>" <?php if(old('parent_id') == $menu->id): echo 'selected'; endif; ?>><?php echo e((app()->getLocale()=='en')? $menu->name_en:$menu->name_ar); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                               
                                <div class="form-group col-md-4">
                                    <label for=""><?php echo e(trans('home.link')); ?></label>
                                    <select name="segment" class="form-control">
                                        <option value=""><?php echo e(__('home.choose_segment')); ?></option>
                                        <?php $__currentLoopData = App\Models\Menu::getSegmentSelect(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key =>$label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($key); ?>" <?php if(old('segment') === $key): echo 'selected'; endif; ?>><?php echo e($label); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/menus')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>

                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/menus/addMenu.blade.php ENDPATH**/ ?>