<?php $__env->startSection('meta'); ?>
<title><?php echo e(trans('home.edit_partner')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.partners')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a
                        href="<?php echo e(url('admin/payment-methods')); ?>"><?php echo e(trans('home.partners')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_partner')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.edit_partner')); ?></h6>
                    </div>
                    <form action="<?php echo e(route('partners.update' , $partner)); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">

                            <div class="form-group col-md-5">
                                <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                <input class="form-control" name="name_en" type="text" value="<?php echo e(old('name_en', $partner->name_en)); ?>"
                                    
                                placeholder="<?php echo e(trans('home.name_en')); ?>" >
                            </div>

                            <div class="form-group col-md-5">
                                <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                <input class="form-control" name="name_ar" type="text" value="<?php echo e(old('name_ar' , $partner->name_ar)); ?>"
                                    placeholder="<?php echo e(trans('home.name_ar')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.order')); ?></label>
                                <input class="form-control" name="order" value="<?php echo e(old('order', $partner->order)); ?>" type="number"
                                    min="1" placeholder="<?php echo e(trans('home.order')); ?>" />
                            </div>

                            <div class="col-md-6">
                                <label><?php echo e(trans('home.logo')); ?> (225px * 225px max 1mb)</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.logo')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="logo">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01"><?php echo e(trans('home.choose_logo')); ?></label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <img src="<?php echo e($partner->logo_path); ?>" width="150">
                            </div>


                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.short_desc_en')); ?></label>
                                <textarea class="form-control area1" name="short_desc_en" type="text"
                                    placeholder="<?php echo e(trans('home.short_desc_en')); ?>"><?php echo old('short_desc_en' , $partner->short_desc_en); ?></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.short_desc_ar')); ?></label>
                                <textarea class="form-control area1" name="short_desc_ar" type="text"
                                    placeholder="<?php echo e(trans('home.short_desc_ar')); ?>"><?php echo old('short_desc_ar' , $partner->short_desc_ar); ?></textarea>
                            </div>


                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.description_en')); ?></label>
                                <textarea class="form-control area1" name="description_en" type="text"
                                    placeholder="<?php echo e(trans('home.description_en')); ?>"><?php echo old('description_en' , $partner->description_en); ?></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.description_ar')); ?></label>
                                <textarea class="form-control area1" name="description_ar" type="text"
                                    placeholder="<?php echo e(trans('home.description_ar')); ?>"><?php echo old('description_ar' , $partner->description_ar); ?></textarea>
                            </div>

                            <div class="form-group col-md-4">
                                <label class=""><?php echo e(trans('home.website')); ?></label>
                                <input class="form-control" name="website" value="<?php echo e(old('website', $partner->website)); ?>" type="text"
                                    placeholder="<?php echo e(trans('home.website')); ?>" />
                            </div>

                            <div class="form-group col-md-4">
                                <label for="name_ar"><?php echo e(trans('home.slug_en')); ?></label>
                                <input type="text" autocomplete="off" class="form-control"
                                    placeholder="<?php echo e(trans('home.slug_en')); ?>" name="slug_en" value="<?php echo e(old('slug_en', $partner->slug_en)); ?>">
                            </div>

                            <div class="form-group col-md-4">
                                <label><?php echo e(trans('home.slug_ar')); ?></label>
                                <input type="text" autocomplete="off" class="form-control"
                                    placeholder="<?php echo e(trans('home.slug_ar')); ?>" name="slug_ar" value="<?php echo e(old('slug_ar', $partner->slug_ar)); ?>">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="ckbox">
                                    <input name="status" value="1"  <?php echo e(old('status', $partner->status) ? 'checked' : ''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                </label>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(route('partners.index')); ?>"><button type="button"
                                        class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/partners/edit.blade.php ENDPATH**/ ?>