<!-- Table -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title pt-3"><?php echo e(__('home.values')); ?></h4>

                <div class="btn btn-list">
                    <a class="btn ripple btn-primary" href="<?php echo e(route('attributes.values.create',[$attribute->id])); ?>"><i class="fas fa-plus-circle"></i> Add attribute values</a>

                </div>
            </div>
            <div class="card-body">
                <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap w-100">
                    <thead>
                        <tr>
                            <th><input type="checkbox" id="checkAll" /></th>
                            <th><?php echo e(__('home.id')); ?></th>
                            <th><?php echo e(__('home.value_en')); ?></th>
                            <th><?php echo e(__('home.value_ar')); ?></th>
                            <th><?php echo e(__('home.code')); ?></th>
                            <th><?php echo e(__('home.status')); ?></th>

                            <th><?php echo e(__('home.actions')); ?></th>
                        </tr>
                    </thead>


                    <tbody>
                        <?php $__currentLoopData = $attribute->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr id="row-<?php echo e($value->id); ?>">
                            <td><input type="checkbox" name="checkbox" class="tableChecked" value="<?php echo e($value->id); ?>" />
                            </td>
                            <td><?php echo e($value->id); ?></td>
                            <td><?php echo e($value->value_en); ?></td>
                            <td><?php echo e($value->value_ar); ?></td>
                            <td><?php echo e($value->code); ?></td>
                            <td>
                                <?php if($value->status == 1): ?>
                                <?php echo e(__('home.yes')); ?>

                                <?php else: ?>
                                <?php echo e(__('home.no')); ?>

                                <?php endif; ?>
                            </td>
                            <td>
                                <!-- Edit Modal Button -->
                               
                                <button type="button" class="btn btn-secondary waves-effect" data-bs-toggle="modal" data-bs-target="#editModal-<?php echo e($value->id); ?>">
                                    <?php echo e(__('home.edit')); ?>

                                </button>
                                
                                <form action="<?php echo e(route('attributes.values.destroy',[$attribute->id,$value->id])); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn btn-danger waves-effect waves-light"><?php echo e(__('home.delete')); ?></button>
                                </form>

                            </td>
                        </tr>


                        <!-- Include the Edit Modal -->
                        <?php echo $__env->make('admin.attribute-values.edit', ['value' => $value], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!-- end cardaa -->
    </div> <!-- end col -->
</div>
<!-- end row -->
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/attribute-values/index.blade.php ENDPATH**/ ?>