<?php $__env->startSection('content'); ?>
<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center"><?php echo e(__('home.search_results')); ?></div>
      
    </div>
</div>
<!-- /page-title -->
<!-- Section Product -->
<section class="flat-spacing-2">
    <div class="container">
        
            <div class="row">
              
                <div class="col-sm-12 col-md-12 col-lg-9">
                   
                    <div class="wrapper-control-shop">
                        <div class="meta-filter-shop"></div>
                        <div class="grid-layout wrapper-shop" data-grid="grid-3">
                            <!-- card product  -->
                            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="card-product" data-brand="brand-<?php echo e($key); ?>"
                                data-price="<?php echo e($product->productStock->price); ?>">
                                <div class="card-product-wrapper">
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('product/'.$product->link)); ?>"
                                        class="product-img">
                                        <img class="lazyload img-product" data-src="<?php echo e($product->main_image_source); ?>"
                                            src="<?php echo e($product->main_image_source); ?>"
                                            alt="<?php echo e($product->alt_main_image); ?>">
                                        <?php if($product->second_image_source): ?>
                                        <img class="lazyload img-hover" data-src="<?php echo e($product->second_image_source); ?>"
                                            src="<?php echo e($product->second_image_source); ?>"
                                            alt="<?php echo e($product->second_image_source); ?>">
                                        <?php endif; ?>

                                    </a>

                                    <?php if(!$product->in_stock): ?>
                                    <span class="alarm"><?php echo e(__('home.out of stock')); ?></span>
                                    <?php endif; ?>

                                    <div class="list-product-btn column-left">
                                        <a href="javascript:void(0);"
                                            class="box-icon wishlist bg_white btn-icon-action">
                                            <span class="icon icon-heart add-wishList-item"
                                                data-product_id="<?php echo e($product->id); ?>"></span>
                                            <span class="tooltip"><?php echo e(__('home.add to wishlist')); ?></span>
                                            <span class="icon icon-delete remove-wishList-item"
                                                data-product_id="<?php echo e($product->id); ?>"></span>
                                        </a>

                                    </div>
                                    <div class="list-product-btn absolute-3">
                                        <a data-product_id="<?php echo e($product->id); ?>" class="box-icon quick-view style-2">
                                            <span class="icon icon-view"></span>
                                            <span class="text"><?php echo e(__('home.Quick View')); ?></span>
                                        </a>

                                        <a data-product_id="<?php echo e($product->id); ?>"
                                            class="box-icon btn-add-to-cart style-2 <?php echo e($product->in_stock ? '' : 'disabled-link'); ?>"
                                            <?php echo e($product->in_stock ? '' : 'aria-disabled=true'); ?>>
                                            <span class="icon icon-bag"></span>
                                            <span class="text"> <?php echo e($product->in_stock ? __('home.Add to Cart') : 'Sold
                                                Out'); ?></span>
                                        </a>

                                    </div>
                                    <!-- Discount percentage -->
                                    <?php if($product->discount): ?>
                                    <div class="on-sale-wrap text-end">
                                        <div class="on-sale-item"><?php echo e($product->productStock?->discount_percentage); ?>%
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>

                                <div class="card-product-info">
                                    <a href="<?php echo e(LaravelLocalization::LocalizeUrl('product/'.$product->link)); ?>"
                                        class="title link"><?php echo e($product->name); ?></a>
                                    <div class="product-prices d-flex justify-content-start">
                                        <?php if($product->discount): ?>
                                        <!-- Original price -->
                                        <span class="compare-at-price"><del><?php echo e($product->productStock?->price); ?> <?php echo e($product->productStock?->currency); ?></del></span>
                                        <!-- price after discount Original price -->
                                        <span class="price"><?php echo e($product->productStock->net_price); ?> <?php echo e($product->currency); ?></span>


                                        <?php else: ?>
                                        <span class="price"><?php echo e($product->productStock->price); ?> <?php echo e($product->currency); ?></span>
                                        <?php endif; ?>
                                    </div>


                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="alert alert-primary" role="alert">
                                no products avalibale
                            </div>
                            <?php endif; ?>


                        </div>
                       
                    </div>
                </div>
            </div>
        
    </div>
</section>

<!-- /Section Product -->

<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/search.blade.php ENDPATH**/ ?>