<?php

use App\Http\Controllers\website\UserBoard\UserAddressController;
use App\Http\Controllers\website\UserBoard\UserBoardController;
use Illuminate\Support\Facades\Route;



Route::prefix('account/')->group(function () {
    Route::group(['controller' => UserBoardController::class, 'as'=>'account.'], function () {
        Route::view('dashboard', 'website.userBoard.dashboard')->name('dashboard');
        Route::get('profile', 'showProfile')->name('profile');
        Route::post('profile/update', 'updateAccountData')->name('update');
        Route::post('/password/update',  'updatePassword')->name('password.update');

        Route::get('orders', 'showOrders')->name('orders');
        Route::get('orders/{order}/details', 'showOrderDetails')->name('order.details');
        Route::get('addresses', 'showAddresses')->name('addresses');
        Route::get('settings', 'showSettings')->name('settings');
    });

    Route::group(['prefix'=>'addresses','controller' => UserAddressController::class , 'as' => 'addresses.'], function () {

        Route::get('/', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::post('update/{address}', 'update')->name('update');
        Route::delete('update/{address}', 'destroy')->name('delete');


    });
});