<div class="account-address-item">
    @if( $address->is_primary == 1 )
    <h6 class="mb_20">{{ __('home.default_address') }}</h6>
    @endif

    <p>{{ $address->full_address }}</p>

    <p>{{ auth()->user()->email }}</p>
    <p class="mb_10">{{ $address->phone }}</p>
    <div class="d-flex gap-10 justify-content-center">
        <button class="tf-btn btn-fill animate-hover-btn justify-content-center btn-edit-address">
            <span>{{ __('home.edit') }}</span>
        </button>
        <form action="{{ route('addresses.delete', $address->id) }}" method="POST">
            @method('DELETE')
            @csrf
            <button type="submit" class="tf-btn btn-outline animate-hover-btn justify-content-center">
                <span>{{ __('home.delete') }}</span>
            </button>
        </form>
        
    </div>
    <form class="edit-form-address wd-form-address" id="formeditAddress" action="{{ route('addresses.update', $address->id) }}" method="POST">
        @csrf
        <div class="title">{{ __('home.edit_address') }}</div>
        <div class="box-field grid-2-lg">
            <div class="tf-field style-1">
                <input class="tf-field-input tf-input" placeholder="{{ trans('home.f_name') }}" value="{{ auth()->user()->f_name }}" type="text" id="firstnameEdit" >
                <label class="tf-field-label fw-4 text_black-2" for="firstnameEdit">{{ trans('home.f_name') }}</label>
            </div>
            <div class="tf-field style-1">
                <input class="tf-field-input tf-input" placeholder="{{ trans('home.l_name') }}" value="{{ auth()->user()->l_name }}" type="text" id="lastnameEdit" >
                <label class="tf-field-label fw-4 text_black-2" for="lastnameEdit">{{ trans('home.l_name') }}</label>
            </div>

        </div>
        <div class="box-field">
            <div class="tf-field style-1">
                <input class="tf-field-input tf-input" placeholder="{{ __('home.phone') }}" value="{{ $address->phone }}" type="tel" id="phone" name="phone">
                <label class="tf-field-label fw-4 text_black-2" for="phone">{{
                        __('home.phone') }}</label>
            </div>
        </div>

        <div class="box-field">
            <label for="countryEdit" class="mb_10 fw-4 text-start d-block text_black-2">{{
                    __('home.country') }}</label>
            <div class="select-custom">
                <select class="tf-select w-100 select2" id="countryEdit" name="country_id">
                    @foreach ($countries as $country )
                    <option value="{{ $country->id }}" {{ $country->id ==
                            $address->country_id ? 'selected' : ''}}>{{$country->name}}
                    </option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="box-field">
            <label for="Governorate" class="mb_10 fw-4 text-start d-block text_black-2">{{
                    __('home.Governorate') }}</label>
            <div class="select-custom">
                <select class="tf-select w-100 Governorate select2"  name="Governorate_id">
                    @foreach ($governorates as $governorate )
                    <option value="{{ $governorate->id }}" {{ $governorate->id ==
                            $address->governorate_id ? 'selected' : ''}}>{{$governorate->name}}
                    </option>
                    @endforeach
                </select>
            </div>
        </div>


        <div class="box-field">
            <div class="tf-field style-1">
                <input class="tf-field-input tf-input" placeholder="{{ __('home.city') }}" value="{{ $address->city }}" type="text" id="addressEdit-{{ $key }}" name="city">
                <label class="tf-field-label fw-4 text_black-2" for="addressEdit">{{ __('home.city') }}</label>
            </div>
        </div>

        <div class="box-field">
            <div class="tf-field style-1">
                <input class="tf-field-input tf-input" placeholder="{{ __('home.address') }}" value="{{ $address->address }}" type="text" id="addressEdit-{{ $key }}" name="address">
                <label class="tf-field-label fw-4 text_black-2" for="addressEdit">{{
                        __('home.address') }}</label>
            </div>
        </div>


        <div class="box-field text-start">
            <div class="box-checkbox fieldset-radio d-flex align-items-center gap-8">
                <input type="checkbox" id="check-edit-address" class="tf-check" name="is_primary" value="1" {{ $address->is_primary == 1 ?
                    'checked': '' }}>
                <label for="check-edit-address" class="text_black-2 fw-4">{{
                        __('home.Set as default address') }}</a>.</label>
            </div>
        </div>
        <div class="d-flex align-items-center justify-content-center gap-20">
            <button type="submit" class="tf-btn btn-fill animate-hover-btn">{{
                    __('home.Update address') }}</button>
            <span class="tf-btn btn-fill animate-hover-btn btn-hide-edit-address">{{
                    __('home.cancel') }}</span>
        </div>
    </form>
</div>

