@extends('layouts.app')
@section('meta')
<title{{ Auth::user()->name }}< /title>
    @endsection
    @section('content')


    <!-- page-title -->
    <div class="tf-page-title">
        <div class="container">
            <div class="heading text-center">{{ __('home.addresses') }}</div>
        </div>
    </div>
    <!-- /page-title -->

    <!-- page-cart -->
    <section class="flat-spacing-11">
        <div class="container">
            <div class="row">
                <div class="col-lg-3">
                    <div class="wrap-sidebar-account">
                        <ul class="my-account-nav">
                            @include('website.userBoard.partials.account-nav')
                        </ul>
                    </div>

                </div>
                <div class="col-lg-9">
                    <div class="my-account-content account-address">
                        <div class="text-center widget-inner-address">
                            <button class="tf-btn btn-fill animate-hover-btn btn-address mb_20">{{__('home.Add a new address')}}</button>
                            
                            @include('website.userBoard.partials.create-address')
                            <div class="list-account-address">
                                @foreach (auth()->user()->addresses as $key => $address )
                                <!-- edit form -->
                                @include('website.userBoard.partials.edit-address')
                                <!-- /edit form -->
                                @endforeach

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- page-cart -->



    @endsection
    @section('script')
   
    @if($errors->any())
        <script>
            toastr.options = {
                "closeButton": true,
                "progressBar": true,
                "positionClass": "toast-top-right"
            };
            @foreach ($errors->all() as $error)
                toastr.error("{{$error}}");
            @endforeach
        </script>
    @endif
@endsection