@extends('layouts.app')
@section('content')
@section('meta')
@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@include('website._breadcrumb', ['page_title' => $category->name])
<section class="flat-spacing-2">
    <div class="container">

        <div class="wrapper-control-shop">
            <div class="tf-grid-layout wrapper-shop tf-col-4" id="gridLayout">
                @forelse ($category->subcategories as $subcategory)
                <div class="swiper-slide">
                    <div class="collection-item-v2 hover-img">
                        <a href="{{ $subcategory->subcategories->count() != 0 ? route('website.categories', $subcategory->link) : route('website.category.products', $subcategory->link) }}" class="collection-inner">
                            <div class="collection-image img-style">
                                <img class="lazyload" data-src="{{ $subcategory->image_path }}" src="{{ $subcategory->image_path }}" alt="{{ $subcategory->name }}">
                            </div>
                            <div class="collection-content">
                                <div class="top wow fadeInUp" data-wow-delay="0s">
                                    <h5 class="heading">{{ $subcategory->name }}</h5>

                                </div>
                                <div class="bottom wow fadeInUp" data-wow-delay="0s">
                                    <button class="tf-btn btn-line collection-other-link fw-6"><span>{{ __('home.shop_now') }}</span><i class="icon icon-arrow1-top-left"></i></button>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
                @empty

                @endforelse


            </div>

        </div>
    </div>
</section>
@endsection
