<script>
    $(document).on('click', '.btn-add-to-sample-request', function() {
        var productId = $(this).data('product_id'); // Retrieve the product ID
        var $form = $('#variant-form');
        // Collect selected variants
        var selectedVariantValues = {};

        $form.find('input[type=radio]:checked').each(function() {
            var name = $(this).attr('name');
            var attributeId = name.match(/\[(\d+)\]/)[1];
            selectedVariantValues[attributeId] = $(this).val();
        });

        
        $.ajax({
            url: "{{ url('sample-request/add') }}" // Update the URL to add to sample request
            , method: 'POST'
            , data: {
                product_id: productId,
                selectedVariantValues: selectedVariantValues,
                _token: '{{ csrf_token() }}' // Include CSRF token for security

            }
            , success: function(data) {
                if (data.status) {
                    $(".count-sampleRequest").text(data.SampleRequestCount);
                    toastr.success(@json(__('Item added to Sample request successfully'))); // Updated message
                }
            }
            , error: function(xhr) {
                if (xhr.status == 401) {
                    window.location.href = "{{ url('login') }}";
                }
            }
        });
    });

</script>
