<script>
    $(document).on('click', '#getCode', function() {
        var couponCode = $('#coupon_code').val();

        $.ajax({
            url: "{{ url('apply-coupon') }}"
            , method: 'POST'
            , data: {
                couponCode: couponCode
                , _token: '{{ csrf_token() }}'
            }
            , success: function(data) {
                if (data.status) {
                    // Retrieve the shipping fees and ensure it's a number
                    var shippingFees = parseFloat($('#shipping_fees_input').val()) || 0;

                    // Calculate the total price by adding shipping fees to the cart total price
                    var totalPrice = shippingFees + parseFloat(data.cart_total_price);

                    // Update the total price displayed in the cart
                    $(".total-price").text(totalPrice + " {{ $cart->currency }}");

                    // Update the hidden input field with the new total price
                    $("input[name='total_price']").val(totalPrice);

                    // Optionally, you can show a success message
                    toastr.success(data.message);
                }
            }
            , error: function(xhr, status, error) {
                // Make sure to display the correct error message
                toastr.error(xhr.responseJSON.message); // Assuming the backend sends `message` key in the response
               
            }
        });

    });

</script>
