<script>
    $(document).on('click', '.tf-mini-cart-remove', function() {
    var cartItemId = $(this).data('cart_item_id');
    var $cartItem = $(this).closest(".tf-mini-cart-item");

    Swal.fire({
        title: "@lang('home.are you sure?')",
        text: "@lang('home.remove selected item')",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#445c4b",
        cancelButtonColor: "#d33",
        confirmButtonText: "@lang('home.yes, delete it')!"
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "{{ url('remove-cart-item') }}",
                method: 'POST',
                data: {
                    cartItemId: cartItemId,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.status) {
                        $cartItem.remove(); // Remove DOM item

                        // Update price and count
                        $(".tf-totals-total-value").text(response.totalPrice + ' ' +response.currency);
                        $(".cartCount").text(response.cartItemsCount);
                        toastr.success("@lang('home.Item removed successfully')");
                        if (response.totalPrice > 0) {
                            // remove form shpopping cart
                        } else {
                            // Render the template directly (requires the template to be in the same DOM)
                            const emptyCartHtml = `@include('website.layouts.modals.partials._empty_cart')`;
                            $(".tf-mini-cart-items").html(emptyCartHtml);
                        }
                    } else {
                        alert('Error removing item from cart');
                    }
                },
                error: function(xhr, status, error) {

                    alert('An error occurred while removing the item');
                }
            });
        }
    });
});


$(document).on('click', '.view-cart-remove-item', function () {
    var cartItemId = $(this).data('cartitem_id');
    var $clickedElement = $(this); // this is the element clicked

    Swal.fire({
        title: "@lang('home.are you sure?')",
        text: "@lang('home.remove selected item')",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#445c4b",
        cancelButtonColor: "#d33",
        confirmButtonText: "@lang('home.yes, delete it')!"
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: "{{ url('remove-cart-item') }}",
                method: 'POST',
                data: {
                    cartItemId: cartItemId,
                    _token: '{{ csrf_token() }}'
                },
                success: function (response) {

                    if (response.status) {
                        let unique_class = $clickedElement.closest('.product-item').data('unique-class');
                        $('.' + unique_class).remove();

                        // Optionally, update total price and item count in UI
                        $('.sub-total-value').text(response.totalPrice + ' {{ config("app.currency") }}');
                        $('.cart-count').text(response.cartItemsCount); // if you have cart count badge

                        // Replace the entire cart modal content with the updated HTML
                         $(".tf-mini-cart-wrap").html(response.html);

                         $(".cartCount").text(response.cartItemsCount);
                    } else {
                        Swal.fire("Error", "Unable to remove item from cart", "error");
                    }
                },
                error: function (xhr, status, error) {

                    Swal.fire("Error", "An error occurred while removing the item", "error");
                }
            });
        }
    });
});
</script>
