<script>
    $(document).on('click', '.plus-btn, .minus-btn', function() {
        var $btn = $(this);
        var cartItemId = $btn.data('cartitem_id');
        var $inputField = $btn.siblings('input');
        var currentQuantity = parseInt($inputField.val());

          // Adjust quantity based on the button clicked
        if ($(this).hasClass('plus-btn')) {
            currentQuantity++;
        } else if ($(this).hasClass('minus-btn') && currentQuantity > 1) {
            currentQuantity--;
        }

        $.ajax({
            url: "{{ url('update-cart-item-quantity') }}"
            , type: "POST"
            , data: {
                _token: "{{ csrf_token() }}"
                , cart_item_id: cartItemId
                , quantity: currentQuantity
            }
            , success: function(response) {

                if (response.status) {
                    toastr.success(@json(__('Quantity Updated successfully')));

                    $(".tf-totals-total-value").text(response.cart_total + ' ' + response.currency);
                    $(".sub-total-value").text(response.cart_total + ' ' + response.currency);

                    // Update only the total for the specific item
                    var $row = $('.cart-' + cartItemId); // target specific row
                    $row.find('.cart-total').text(response.cartItem + ' ' + response.currency);

                     // Replace the entire cart modal content with the updated HTML
                     $(".tf-mini-cart-wrap").html(response.html);
                } else {
                    toastr.error(@json(__("Can't Update Quantity")));
                    var $row = $('.cart-' + cartItemId);

                    $row.find('input[name="number"]').val(response.cartItemQuantity);
                    $('input.quantity-input[data-cartitem_id="' + cartItemId + '"]').val(response.cartItemQuantity);

                }
            }
            , error: function(xhr) {
                alert("Error updating cart: " + xhr.responseText);
            }
            , complete: function() {
                $btn.prop('disabled', false); // Re-enable button
            }
        });
    });

</script>
