@extends('layouts.app')
@section('meta')
@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@section('content')
<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center">{{ __('home.products') }}</div>
        {{-- <p class="text-center text-2 text_black-2 mt_5">Shop through our latest selection of Fashion</p> --}}
    </div>
</div>
<!-- /page-title -->
<!-- Section Product -->
<section class="flat-spacing-2">
    <div class="container">
        <form action="{{ LaravelLocalization::LocalizeUrl('products')}}" method="GET" id="facet-filter-form"
            class="facet-filter-form">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-3">
                    <div class="canvas-wrapper">
                        <header class="canvas-header">
                            <div class="tf-btn-filter">
                                <span class="icon icon-filter"></span>
                                <span>{{ __('home.filter') }}</span>
                            </div>
                        </header>
                        <div class="tf-shop-sidebar wrap-sidebar-mobile">

                            <!-- filter-by-attributes -->

                            @foreach ($attributes as $key => $attribute )
                            <div class="widget-facet">
                                <div class="facet-title" data-bs-target="#attribute-{{$key }}" data-bs-toggle="collapse"
                                    aria-expanded="true" aria-controls="attribute-{{$key }}">
                                    <span>{{ $attribute->name }}</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>

                                <div id="attribute-{{$key}}" class="collapse show">
                                    <ul class="tf-filter-group current-scrollbar mb_36">
                                        @foreach ($attribute->values as $index => $attributeValue)

                                        <li class="list-item d-flex gap-12 align-items-center">
                                            <input type="checkbox" name="filter_attributeValues[{{ $attribute->id }}][]"
                                                value="{{ $attributeValue->id }}" class="tf-check"
                                                id="attribute-value-{{$attributeValue->id}}" {{
                                                isset(request('filter_attributeValues')[$attribute->id]) &&
                                            in_array($attributeValue->id,
                                            request('filter_attributeValues')[$attribute->id]) ? 'checked' : '' }}>
                                            <label for="attribute-value-{{$attributeValue->id}}" class="label">
                                                <span>{{ $attributeValue->value
                                                    }}</span>&nbsp;<span>({{$attributeValue->attribute->products->count()}})</span>
                                            </label>
                                        </li>
                                        @endforeach
                                    </ul>
                                </div>

                            </div>
                            @endforeach

                            <!-- /end-filter-by-attributes -->

                            <!-- filter-by-range-price -->

                            <div class="widget-facet">
                                <div class="facet-title" data-bs-target="#price" data-bs-toggle="collapse"
                                    aria-expanded="true" aria-controls="price">
                                    <span>{{ __('home.price') }}</span>
                                    <span class="icon icon-arrow-up"></span>
                                </div>
                                <div id="price" class="collapse show">
                                    <div class="widget-price filter-price">
                                        <div class="tow-bar-block">
                                            <div class="progress-price"></div>
                                        </div>
                                        <div class="range-input">
                                            <input class="range-min" type="range" min="{{ $minPriceProduct }}"
                                                max="{{ $maxPriceProduct }}" name="min_range"
                                                value="{{ request('min_range', $minPriceProduct) }}" />
                                            <input class="range-max" type="range" min="{{ $minPriceProduct }}"
                                                max="{{ $maxPriceProduct }}" name="max_range"
                                                value="{{ request('max_range', $maxPriceProduct) }}" />
                                        </div>
                                        <div class="box-title-price">
                                            <span class="title-price">{{ __('home.price') }} :</span>
                                            <div class="caption-price">
                                                <div>
                                                    <span>{{ __('home.EGP') }}</span>
                                                    <span class="min-price">{{ request('min_range', $minPriceProduct)
                                                        }}</span>
                                                </div>
                                                <span>-</span>
                                                <div>
                                                    <span>{{ __('home.EGP') }}</span>
                                                    <span class="max-price">{{ request('max_range', $maxPriceProduct)
                                                        }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <!-- /end-filter-by-range-price -->

                        </div>

                    </div>
                </div>
                <div class="col-sm-12 col-md-12 col-lg-9">
                    <div class="tf-shop-control grid-1 align-items-center">
                        <div class="tf-control-sorting d-flex justify-content-end">
                            <div class="tf-dropdown">
                                <select class="btn-select form-select" name="sort_by" id="sortOptions">
                                    <option value="date-new-to-old" {{ request('sort_by')=='date-new-to-old'
                                        ? 'selected' : '' }}>{{ __('home.Date, new to old') }}</option>
                                    <option value="featured" {{ request('sort_by')=='featured' ? 'selected' : '' }}>
                                        Featured</option>
                                    <option value="price-low-to-high" {{ request('sort_by')=='price-low-to-high'
                                        ? 'selected' : '' }}>{{ __('home.Price, low to high') }}</option>
                                    <option value="price-high-to-low" {{ request('sort_by')=='price-high-to-low'
                                        ? 'selected' : '' }}>{{ __('home.Price, high to low') }}</option>
                                    <option value="date-old-to-new" {{ request('sort_by')=='date-old-to-new'
                                        ? 'selected' : '' }}>{{__('home.Date, old to new')}}</option>

                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="wrapper-control-shop">
                        <div class="meta-filter-shop"></div>
                        <div class="grid-layout wrapper-shop" data-grid="grid-3">
                            <!-- card product  -->
                            @forelse ($products as $key=>$product )
                            <div class="card-product" data-brand="brand-{{ $key }}"
                                data-price="{{ $product->productStock->price }}">
                                <div class="card-product-wrapper">
                                    <a href="{{ LaravelLocalization::LocalizeUrl('product/'.$product->link) }}"
                                        class="product-img">
                                        <img class="lazyload img-product" data-src="{{ $product->main_image_source }}"
                                            src="{{ $product->main_image_source }}"
                                            alt="{{ $product->alt_main_image }}">
                                        @if($product->second_image_source)
                                        <img class="lazyload img-hover" data-src="{{ $product->second_image_source }}"
                                            src="{{ $product->second_image_source }}"
                                            alt="{{ $product->second_image_source }}">
                                        @endif

                                    </a>

                                    @if(!$product->in_stock)
                                    <span class="alarm">{{ __('home.out of stock') }}</span>
                                    @endif

                                    <div class="list-product-btn column-left">
                                        <a href="javascript:void(0);"
                                            class="box-icon wishlist bg_white btn-icon-action">
                                            <span class="icon icon-heart add-wishList-item"
                                                data-product_id="{{ $product->id }}"></span>
                                            <span class="tooltip">{{__('home.add to wishlist')}}</span>
                                            <span class="icon icon-delete remove-wishList-item"
                                                data-product_id="{{ $product->id }}"></span>
                                        </a>

                                    </div>
                                    <div class="list-product-btn absolute-3">
                                        <a data-product_id="{{  $product->id }}" class="box-icon quick-view style-2">
                                            <span class="icon icon-view"></span>
                                            <span class="text">{{__('home.Quick View')}}</span>
                                        </a>

                                        <a data-product_id="{{ $product->id }}"
                                            class="box-icon btn-add-to-cart style-2 {{ $product->in_stock ? '' : 'disabled-link' }}"
                                            {{ $product->in_stock ? '' : 'aria-disabled=true' }}>
                                            <span class="icon icon-bag"></span>
                                            <span class="text"> {{ $product->in_stock ? __('home.Add to Cart') : 'Sold
                                                Out' }}</span>
                                        </a>

                                    </div>
                                    <!-- Discount percentage -->
                                    @if($product->discount)
                                    <div class="on-sale-wrap text-end">
                                        <div class="on-sale-item">{{ $product->productStock?->discount_percentage}}%
                                        </div>
                                    </div>
                                    @endif
                                </div>

                                <div class="card-product-info">
                                    <a href="{{ LaravelLocalization::LocalizeUrl('product/'.$product->link) }}"
                                        class="title link">{{ $product->name }}</a>
                                    <div class="product-prices d-flex justify-content-start">
                                        @if($product->discount)
                                        <!-- Original price -->
                                        <span class="compare-at-price"><del>{{ $product->productStock?->price }} {{
                                                $product->productStock?->currency }}</del></span>
                                        <!-- price after discount Original price -->
                                        <span class="price">{{ $product->productStock->net_price }} {{
                                            $product->currency}}</span>


                                        @else
                                        <span class="price">{{ $product->productStock->price }} {{
                                            $product->currency}}</span>
                                        @endif
                                    </div>


                                </div>
                            </div>
                            @empty
                            <div class="alert alert-primary" role="alert">
                                no products avalibale
                            </div>
                            @endforelse


                        </div>
                        @if(count($products) > 0)
                        <!-- Pagination -->
                        <ul class="tf-pagination-wrap tf-pagination-list tf-pagination-btn">
                            <!-- Previous Page -->
                            @if($products->onFirstPage())
                            <li>
                                <a href="javascript:void(0)" class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-left"></span>
                                </a>
                            </li>
                            @else
                            <li>
                                <a href="{{ $products->appends(request()->except('page'))->previousPageUrl() }}"
                                    class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-left"></span>
                                </a>
                            </li>
                            @endif

                            <!-- Pagination Links -->
                            @if($products->hasPages())
                            @foreach($products->getUrlRange(1, $products->lastPage()) as $page => $url)
                            <li class="{{ $page == $products->currentPage() ? 'active' : '' }}">
                                <a href="{{ $url . '&' . http_build_query(request()->except('page')) }}"
                                    class="pagination-link animate-hover-btn">
                                    {{ $page }}
                                </a>
                            </li>
                            @endforeach
                            @endif

                            <!-- Next Page -->
                            @if($products->hasMorePages())
                            <li>
                                <a href="{{ $products->appends(request()->except('page'))->nextPageUrl() }}"
                                    class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-right"></span>
                                </a>
                            </li>
                            @else
                            <li>
                                <a href="javascript:void(0)" class="pagination-link animate-hover-btn">
                                    <span class="icon icon-arrow-right"></span>
                                </a>
                            </li>
                            @endif
                        </ul>
                        @endif
                    </div>
                </div>
            </div>
        </form>
    </div>
</section>
<div class="btn-sidebar-style2">
    <button data-bs-toggle="offcanvas" data-bs-target="#sidebarmobile" aria-controls="offcanvas">{{ __('home.filter') }} <span class="icon icon-filter"></span></button>
</div>
<!-- /Section Product -->
    <!-- Filter sidebar-->
    <div class="offcanvas offcanvas-start canvas-filter canvas-sidebar" id="sidebarmobile">
    <form action="{{ LaravelLocalization::LocalizeUrl('products')}}" method="GET" id="facet-filter-form"
    class="facet-filter-form">
        <div class="canvas-wrapper">
            <header class="canvas-header">
                <span class="title">{{ __('home.filter') }}</span>
                <span class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></span>
            </header>
            <div class="canvas-body sidebar-mobile-append">
            
            </div>
            
        </div>   
    </form>    
    </div>
    <!-- End Filter sidebar -->

@endsection


@section('script')
<script>
    // Select all checkboxes or radio buttons within the form
    const form = document.getElementById('facet-filter-form');


    $(document).ready(function() {
        $("form").on("change", "input:checkbox", function() {
            form.submit();
        });
    });



    document.querySelector('select[name="sort_by"]').addEventListener('change', function() {
        form.submit();
    });

</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const minRangeInput = document.querySelector('.range-min');
        const maxRangeInput = document.querySelector('.range-max');
        const form = document.getElementById('facet-filter-form');

        function updatePriceAndSubmit() {
            if (parseInt(minRangeInput.value) <= parseInt(maxRangeInput.value)) {
                form.submit();
            } else {
                alert('Minimum price should not exceed maximum price.');
            }
        }

        minRangeInput.addEventListener('change', updatePriceAndSubmit);
        maxRangeInput.addEventListener('change', updatePriceAndSubmit);
    });

</script>
@endsection