@props([
    'product',
    'images',
    'mainImage',
    'mainImageAlt'
])

<div class="thumbs-slider">
    {{-- Thumbnail Slider --}}
    <div dir="ltr" class="swiper tf-product-media-thumbs other-image-zoom" data-direction="vertical">
        <div class="swiper-wrapper stagger-wrap">
            @forelse($images as $key => $image)
                <div class="swiper-slide stagger-item" data-color="beige">
                    <div class="item">
                        <img class="lazyload"
                             data-src="{{ $image->imagePath('products/' . ($product->variants->isNotEmpty() ? 'variants' : 'images'), $image->image) }}"
                             src="{{ $image->imagePath('products/' . ($product->variants->isNotEmpty() ? 'variants' : 'images'), $image->image) }}"
                             alt="img-{{ $product->name . '-' . $key }}">
                    </div>
                </div>
            @empty
                <div class="swiper-slide stagger-item" data-color="beige">
                    <div class="item">
                        <img class="lazyload" data-src="{{ $mainImage }}" src="{{ $mainImage }}" alt="{{ $mainImageAlt }}">
                    </div>
                </div>
            @endforelse
        </div>
    </div>

    {{-- Main Image Slider --}}
    <div dir="ltr" class="swiper tf-product-media-main" id="gallery-swiper-started">
        <div class="swiper-wrapper">
            @forelse($images as $key => $image)
                <div class="swiper-slide" data-color="beige">
                    <a href="{{ $image->imagePath('products/' . ($product->variants->isNotEmpty() ? 'variants' : 'images'), $image->image) }}"
                       target="_blank" class="item" data-pswp-width="770px" data-pswp-height="1075px">
                        <img class="tf-image-zoom lazyload"
                             data-zoom="{{ $image->imagePath('products/' . ($product->variants->isNotEmpty() ? 'variants' : 'images'), $image->image) }}"
                             data-src="{{ $image->imagePath('products/' . ($product->variants->isNotEmpty() ? 'variants' : 'images'), $image->image) }}"
                             src="{{ $image->imagePath('products/' . ($product->variants->isNotEmpty() ? 'variants' : 'images'), $image->image) }}"
                             alt="img-{{ $product->name . '-' . $key }}">
                    </a>
                </div>
            @empty
                <div class="swiper-slide" data-color="beige">
                    <a href="{{ $mainImage }}" target="_blank" class="item" data-pswp-width="770px" data-pswp-height="1075px">
                        <img class="tf-image-zoom lazyload" data-zoom="{{ $mainImage }}" data-src="{{ $mainImage }}" src="{{ $mainImage }}" alt="{{ $mainImageAlt }}">
                    </a>
                </div>
            @endforelse
        </div>
        <div class="swiper-button-next button-style-arrow thumbs-next"></div>
        <div class="swiper-button-prev button-style-arrow thumbs-prev"></div>
    </div>
</div>