  <div class="tf-minicart-recommendations">
      <div class="tf-minicart-recommendations-heading">
          <div class="tf-minicart-recommendations-title">You may also like</div>
          <div class="sw-dots small style-2 cart-slide-pagination"></div>
      </div>
      <div dir="ltr" class="swiper tf-cart-slide">
          <div class="swiper-wrapper">
            @forelse ($related_cart_products as $product)
            @if($product->has_variants)
                <div class="swiper-slide">
                    <div class="tf-minicart-recommendations-item card-product">
                        <div class="tf-minicart-recommendations-item-image">
                                <a href="{{ route('product.details', $product->link) }}">
                                    <img class="lazyload img-product" data-src="{{ $product->defaultVariant->first_image }}" src="{{ $product->defaultVariant->first_image }}" alt="{{ $product->name }} - {{ $product->defaultVariant->color }}">

                                </a>
                        </div>

                         <div class="tf-minicart-recommendations-item-infos flex-grow-1">
                             <a class="title" href="{{ route('product.details', $product->link) }}">{{ $product->name }}</a>
                             <div class="price">
                              @if($product->isOnSale(($product->defaultVariant->id)))
                                <div class="sale-price">
                                    <strong>Now:</strong> {{ config('app.currency') }} {{ $product->getEffectivePrice($product->defaultVariant->id) }}
                                </div>
                                <div class="original-price">
                                    <strong>Before sale price:</strong>
                                    <del>{{ config('app.currency') }} {{ $product->getOriginalPrice($product->defaultVariant->id) }}</del>
                                </div>
                                <div class="save-discount">
                                    <strong>Save:</strong> {{ config('app.currency') }} {{ $product->getDiscountAmount($product->defaultVariant->id) }}
                                </div>
                                @else
                                <span class="original-price">{{ config('app.currency') }} {{ $product->getOriginalPrice($product->defaultVariant->id) }}</span>
                                @endif
                             </div>
                        </div>

                         <ul class="list-color-product">

                                @foreach ($product->available_colors as $colorGroup)

                                    <li class="list-color-item color-swatch {{ $loop->first ? 'active' : '' }}" data-currency="{{ config('app.currency') }}" data-color="{{ $colorGroup['color'] }}" data-is-on-sale="{{ $product->isOnSale($colorGroup['variant_id']) }}" data-original-price="{{ $product->getOriginalPrice($colorGroup['variant_id']) }}" data-effective-price="{{ $product->getEffectivePrice($colorGroup['variant_id']) }}" data-discount-amount="{{ $product->getDiscountAmount($colorGroup['variant_id']) }}">
                                        <span class="tooltip">{{ $colorGroup['color'] }}</span>
                                        <span class="swatch-value" style="background-color:{{$colorGroup['color']  }}"></span>
                                        <img class="lazyload" data-src="{{ $colorGroup['image'] }}" src="{{ $colorGroup['image'] }}" alt="{{ $product->name }} - {{ $colorGroup['color'] }}">
                                    </li>
                                @endforeach
                         </ul>

                        <div class="tf-minicart-recommendations-item-quickview">
                                <div class="btn-show-quickview quickview hover-tooltip">
                                    <span class="icon icon-view"></span>
                                </div>
                        </div>
                    </div>
                </div>
            @else
                    <div class="swiper-slide">
                        <div class="tf-minicart-recommendations-item">
                            <div class="tf-minicart-recommendations-item-image">
                                <a href="{{ route('product.details', $product->link) }}">
                                    <img src="{{ $product->main_image_path }}" alt="{{ $product->name }}">
                                </a>
                            </div>
                            <div class="tf-minicart-recommendations-item-infos flex-grow-1">
                                <a class="title" href="{{ route('product.details', $product->link) }}">
                                    {{ $product->name }}
                                </a>
                                <div class="tf-product-info-price">
                                    <div class="product-pricing">
                                        @if($product->isOnSale())
                                        <div class="sale-price">
                                            <strong>Now:</strong> {{ config('app.currency') }} {{ $product->getEffectivePrice() }}
                                        </div>
                                        <div class="original-price">
                                            <strong>Before sale price:</strong>
                                            <del>{{ config('app.currency') }} {{ $product->getOriginalPrice() }}</del>
                                        </div>
                                        <div class="save-discount">
                                            <strong>Save:</strong> {{ config('app.currency') }} {{ $product->getDiscountAmount() }}
                                        </div>
                                        @else
                                        <span class="original-price">{{ config('app.currency') }} {{ $product->getOriginalPrice() }}</span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="tf-minicart-recommendations-item-quickview">
                                <div class="btn-show-quickview quickview hover-tooltip">
                                    <span class="icon icon-view"></span>
                                </div>
                            </div>
                        </div>
                    </div>

            @endif

            @empty
                {{-- No related products --}}
            @endforelse
          </div>
       </div>
      </div>
  </div>
  </div>
