@extends('layouts.app')
@section('meta')
@php echo $metatags @endphp

@php echo $schema @endphp
@endsection
@section('content')
<!-- page-title -->
@include('website._breadcrumb', ['page_title' => __('home.inspection_request')])
<!-- /page-title -->


<!-- form -->
<section class="flat-spacing-21">
    <div class="container">
        <div class="tf-grid-layout gap30 lg-col-2">
            <div class="tf-content-left">

                <figure class="br-lg">
                    @if(app()->getLocale() == 'ar')
                       <img src="{{asset('assets/front/images/inspection_request.png')}}" alt="commercials request image" width="610" height="500"/>
                    @else
                     <img src="{{asset('assets/front/images/inspection_request.png')}}" alt="commercials request image" width="610" height="500"/>
                    @endif
                 
                </figure>
            </div>
            <div class="tf-content-right">
                <div class="tf-page-cart-item">
                    
                    <form action="{{ route('website.saveInspectionRequest') }}" method="POST" class="form-checkout">
                        @csrf
                        <div  class="box fieldset">
                            <fieldset class="fieldset">
                                <label for="first-name">{{ __('home.name') }}</label>
                                <input type="text" id="first-name" placeholder="{{ __('home.name') }}" value="{{  old('name') }}" name='name' required>
                            </fieldset>
                            
                        </div>
    
                        <div class="box grid-2">
                            <fieldset class="box fieldset">
                                <label for="phone">{{ __('home.Phone Number') }}</label>
                                <input type="number" id="phone" placeholder="{{ __('Enter phone number') }}" name="phone" value="{{ old('phone') }}" required>
                            </fieldset>
                            <fieldset class="box fieldset">
                                <label for="email">{{ __('home.Email') }}</label>
                                <input type="email" id="email" placeholder="{{ __('Enter email') }}" name="email" value="{{ old('email') }}">
                            </fieldset>
                        </div>
    
                        <fieldset class="box fieldset">
                            <label for="country">{{ __('home.country') }}</label>
                            <div class="select-custom">
                                <select class="tf-select w-100" id="country" name="country_id" required data-default="">
                                    <option value="null">{{ __('home.select_country') }}</option>
                                    @foreach ($countries as $country)
                                    <option value="{{ $country->id }}" selected>{{ $country->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </fieldset>
    
                        <div class="box grid-2">
                            <fieldset>
                                <label for="governorates">{{ __('home.governorates') }}</label>
                                <div class="select-custom">
                                    <select class="tf-select w-100 governorate" id="governorates" name="governorate_id" required data-default="">
                                        <option value="null">{{ __('home.select_governorate') }}</option>
                                        @foreach ($governorates as $governorate)
                                        <option value="{{ $governorate->id }}">{{ $governorate->name }}</option>
                                        @endforeach
                                    </select>
                            </fieldset>
    
                            <fieldset class="box fieldset">
                                <label for="city">{{ __('home.Town/City') }}</label>
                                <input type="text" id="city" placeholder="{{ __('home.Town/City') }}" name="city" value="{{ old('city') }}" required>
                            </fieldset>
                        </div>
    
    
    
                        <fieldset class="box fieldset">
                            <label for="address">{{ __('home.Address') }}</label>
                            <input type="text" id="address" placeholder="{{ __('home.Address') }}" name="address" value="{{ old('address') }}" required>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="note">{{ __('home.Order notes (optional)') }}</label>
                            <textarea name="note" id="note">{{ old('note') }}</textarea>
                        </fieldset>
    
                   
                        <div class="box">
                         
                            <button type="submit" class="tf-btn radius-3 btn-fill btn-icon animate-hover-btn justify-content-center">{{ __('home.send_request') }}</button>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /form -->



@endsection
