<div class="card-product bg_white radius-0">
    <div class="card-product-wrapper">
        <a href="{{ route('product.details',$product->link) }}" class="product-img">
            <img class="lazyload img-product" data-src="{{ $product->main_image_path }}" src="{{ $product->main_image_path }}" alt="image-product">
            <img class="lazyload img-hover" data-src="{{ $product->main_image_path }}" src="{{ $product->main_image_path }}" alt="image-product">
        </a>
        @if($product->isInStock() == false)
            <span class="alarm">{{ __('home.out of stock') }}</span>
        @endif
        
        <div class="list-product-btn absolute-2">
            <button type="button" class="box-icon bg_white tf-btn-loading btn-add-to-cart " data-product_id="{{ $product->id }}" @disabled($product->isInStock() == false)
                title="{{ $product->isInStock() == false ? 'Out of stock' : 'Add to cart' }}">
                <span class="icon icon-bag"></span>
                <span class="tooltip">{{ $product->isInStock() == false ? 'Out of stock' : 'Add to cart' }}</span>
            </button>
            <a href="javascript:void(0);" class="box-icon bg_white wishlist btn-icon-action">
                <span class="icon icon-heart add-wishList-item" data-product_id="{{ $product->id }}"></span>
                <span class="tooltip">{{__('home.add to wishlist')}}</span>
                <span class="icon icon-delete remove-wishList-item" data-product_id="{{ $product->id }}"></span>
            </a>
            {{-- <a href="#compare" data-bs-toggle="offcanvas" aria-controls="offcanvasLeft"
                class="box-icon bg_white compare btn-icon-action">
                <span class="icon icon-compare"></span>
                <span class="tooltip">Add to Compare</span>
                <span class="icon icon-check"></span>
            </a> --}}
            {{-- <a href="#quick_view" data-bs-toggle="modal" class="box-icon bg_white quickview tf-btn-loading">
                <span class="icon icon-view"></span>
                <span class="tooltip">Quick View</span>
            </a> --}}
        </div>

    </div>
    <div class="card-product-info has-padding">
        <a href="{{ route('product.details',$product->link) }}" class="title link">{{
            $product->name }}</a>
        <div class="tf-product-info-price">
            <div class="product-pricing">
                @if($product->isOnSale())
                <div class="sale-price">
                    <strong>Now:</strong> {{ config('app.currency') }} {{ $product->getEffectivePrice() }}
                </div>
                <div class="original-price">
                    <strong>Before sale price:</strong>
                    <del>{{ config('app.currency') }} {{ $product->getOriginalPrice() }}</del>
                </div>
                <div class="save-discount">
                    <strong>Save:</strong> {{ config('app.currency') }} {{ $product->getDiscountAmount() }}
                </div>
                @else
                <span class="original-price">{{ config('app.currency') }} {{ $product->getOriginalPrice() }}</span>
                @endif
            </div>
        </div>

    </div>
</div>
