 <!-- Filter -->
    <div class="offcanvas offcanvas-start canvas-filter" id="filterShop">
        <div class="canvas-wrapper">
            <header class="canvas-header">
                <div class="filter-icon">
                    <span class="icon icon-filter"></span>
                    <span>Filter</span>
                </div>
                <span class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></span>
            </header>
            <div class="canvas-body">
                <div class="widget-facet wd-categories">
                    <div class="facet-title" data-bs-target="#categories" data-bs-toggle="collapse" aria-expanded="true"
                        aria-controls="categories">
                        <span>Product categories</span>
                        <span class="icon icon-arrow-up"></span>
                    </div>
                    <div id="categories" class="collapse show">
                        <ul class="list-categoris current-scrollbar mb_36">
                            @foreach ($other_categories as  $other_category )
                                  <li class="cate-item {{ $loop->first ?'current' : '' }}"><a href="{{  route('website.category.products',$other_category->link)  }}"><span>{{ $other_category->name }}</span></a></li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <form action="{{ route('website.category.products' , $category->link) }}" id="facet-filter-form" class="facet-filter-form" method="GET">
                    <div class="widget-facet">
                        <div class="facet-title" data-bs-target="#availability" data-bs-toggle="collapse"
                            aria-expanded="true" aria-controls="availability">
                            <span>Availability</span>
                            <span class="icon icon-arrow-up"></span>
                        </div>
                        <div id="availability" class="collapse show">
                            <ul class="tf-filter-group current-scrollbar mb_36">
                                <li class="list-item d-flex gap-12 align-items-center">
                                    <input type="checkbox" id="inStock" name="filter_availability[stock][]" value="1" class="tf-check" @checked(collect(request('filter_availability.stock'))->contains(1))>
                                    <label for="inStock" class="label"><span>In stock</span></label>
                                </li>
                                <li class="list-item d-flex gap-12 align-items-center">
                                    <input type="checkbox" id="outStock" name="filter_availability[stock][]" value="0" class="tf-check" @checked(collect(request('filter_availability.stock'))->contains(0))>
                                    <label for="outStock" class="label"><span>Out of stock</span></label>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="widget-facet">
                        <div class="facet-title" data-bs-target="#price" data-bs-toggle="collapse" aria-expanded="true"
                            aria-controls="price">
                            <span>Price</span>
                            <span class="icon icon-arrow-up"></span>
                        </div>
                        <div id="price" class="collapse show">
                            <div class="widget-price filter-price">
                                <div class="price-val-range" id="price-value-range" data-min="{{ $minPrice }}" data-max="{{ $maxPrice }}"></div>
                                <div class="box-title-price">
                                    <span class="title-price">Price :</span>
                                    <div class="caption-price">
                                        <div class="price-val" id="price-min-value" data-currency="{{ config('app.currency') }}"></div>
                                        <span>-</span>
                                        <div class="price-val" id="price-max-value" data-currency="{{ config('app.currency') }}"></div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="widget-facet">
                        <div class="facet-title" data-bs-target="#color" data-bs-toggle="collapse" aria-expanded="true"
                            aria-controls="color">
                            <span>Color</span>
                            <span class="icon icon-arrow-up"></span>
                        </div>
                        <div id="color" class="collapse show">
                            <ul class="tf-filter-group filter-color current-scrollbar mb_36">
                                @foreach ($categoryColors as $index => $categoryColor)
                                <li class="list-item d-flex gap-12 align-items-center">
                                    <input type="checkbox" 
                                           name="color[]" 
                                           class="tf-check-color" 
                                           style="background-color: {{ $categoryColor->code }}" 
                                           id="color-{{ $index }}"
                                           value="{{ $categoryColor->id }}">
                                    <label for="color-{{ $index }}" class="label">
                                        <span>{{ $categoryColor->value }}</span>
                                    </label>
                                </li>
                                @endforeach
                            </ul>
                            
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
    <!-- End Filter -->
