@extends('layouts.app')
@section('meta')
@php echo $metatags @endphp

@php echo $schema @endphp
@endsection
@section('content')
<!-- page-title -->
@include('website._breadcrumb', ['page_title' => __('home.contact-us')])
<!-- /page-title -->


<!-- form -->
<section class="flat-spacing-21">
    <div class="container">
        <div class="tf-grid-layout gap30 lg-col-2">
            <div class="tf-content-left">

                @forelse ($site_addresses as $site_address )

                <h5 class="mb_20">{{ $site_address->title }}</h5>
                <div class="mb_20">
                    <p class="mb_15"><strong>{{ __('home.address') }}</strong></p>
                    <p>{!! $site_address->address !!}</p>
                </div>
                <div class="mb_20">
                    <p class="mb_15"><strong>{{ ('home.phone') }}</strong></p>
                    <p>{{ $site_address->phone1 }}</p>
                </div>
                <div class="mb_20">
                    <p class="mb_15"><strong>{{ __('home.email') }}</strong></p>
                    <p>{{ $site_address->email }}</p>
                </div>
                @empty

                @endforelse

                <div>
                    <ul class="tf-social-icon d-flex gap-20 style-default">
                        @if(config('setting_facebook'))
                        <li><a href="{{ config('setting_facebook') }}" target="_blank" class="box-icon link round social-facebook border-line-black"><i class="icon fs-14 icon-fb"></i></a></li>
                        @endif
                        @if(config('setting_twitter'))
                        <li><a href=" {{ config('setting_twitter') }} " class="box-icon link round social-twiter border-line-black"><i class="icon fs-12 icon-Icon-x"></i></a></li>
                        @endif
                        @if(config('setting_instagram'))
                        <li><a href=" {{ config('setting_instagram') }} " class="box-icon link round social-instagram border-line-black"><i class="icon fs-14 icon-instagram"></i></a></li>
                        @endif
                        @if(config('setting_tiktok'))

                        <li><a href=" {{ config('setting_tiktok') }}" class="box-icon link round social-tiktok border-line-black"><i class="icon fs-14 icon-tiktok"></i></a></li>
                        @endif


                    </ul>
                </div>
            </div>
            <div class="tf-content-right">
                <h5 class="mb_20">{{ __('home.contact-us') }}</h5>

                <div>
                    <form class="form-contact" id="contactform" action="{{route('website.saveContact')}}" method="post">
                        @csrf
                        <div class="d-flex gap-15 mb_15">
                            <fieldset class="w-100">
                                <input type="text" id="first-name" placeholder="{{ __('home.name') }}" value="{{ old('name') }}" name='name'>

                                @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror

                            </fieldset>
                            <fieldset class="w-100">
                                <input type="tel" name="phone" id="phone" required placeholder="{{ __('home.phone') }}" />

                                @error('phone')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror

                            </fieldset>
                        </div>
                        
                        <div class="d-flex gap-15 mb_15">

                            <fieldset class="w-100">
                                <input type="email" name="email" id="email" required placeholder="{{ __('home.email') }}" />

                                @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror

                            </fieldset>
                        </div>

                        <div class="mb_15">
                            <textarea placeholder="{{ __('home.message') }}" name="message" id="message" required cols="30" rows="10">{{ old('message') }}</textarea>
                            @error('message')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                            @enderror
                        </div>
                        <div class="send-wrap">
                            <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">{{__('home.submit') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /form -->

<!-- Map -->
<section class="bg_grey-7 ">
    <div class="container-fluid">

        <div class="w-100">
            <iframe src="{{ config('setting_map_url') }}" width="100%" height="400px" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
        </div>

    </div>
</section>
<!-- /Map -->



@endsection
