@extends('layouts.app')
@section('meta')
<title>
    {{ __('home.Check Out') }}
</title>
@endsection
@section('content')
<!-- page-title -->
@include('website._breadcrumb', ['page_title' => __('home.Check Out')])
<!-- /page-title -->

<!-- page-cart -->
<section class="flat-spacing-11">
    <div class="container">
        <div class="tf-page-cart-wrap layout-2">
            <div class="tf-page-cart-item">
                <h5 class="fw-5 mb_20">{{ __('home.Billing details') }}</h5>
                <form action="{{ route('place.order') }}" method="POST" class="form-checkout">
                    @csrf
                    <div class="box grid-2">
                        <fieldset class="fieldset">
                            <label for="first-name">{{ __('home.f_name') }}</label>
                            <input type="text" id="first-name" placeholder="{{ __('home.f_name') }}" value="{{ auth()->user()->f_name ?? old('f_name') }}" name='f_name' required>
                        </fieldset>
                        <fieldset class="fieldset">
                            <label for="last-name">{{ __('home.l_name') }}</label>
                            <input type="text" id="last-name" placeholder="{{ __('home.l_name') }}" value="{{ auth()->user()->l_name ?? old('l_name') }}" name='l_name' required>
                        </fieldset>
                    </div>

                    <div class="box grid-2">
                        <fieldset class="box fieldset">
                            <label for="phone">{{ __('home.Phone Number') }}</label>
                            <input type="number" id="phone" placeholder="{{ __('Enter phone number') }}" name="phone" value="{{ old('phone') }}" required>
                        </fieldset>
                        <fieldset class="box fieldset">
                            <label for="email">{{ __('home.Email') }}</label>
                            <input type="email" id="email" placeholder="{{ __('Enter email') }}" name="email" value="{{ old('email') }}">
                        </fieldset>
                    </div>

                    <fieldset class="box fieldset">
                        <label for="country">{{ __('home.country') }}</label>
                        <div class="select-custom">
                            <select class="tf-select w-100" id="country" name="country_id" required data-default="">
                                <option value="null">{{ __('home.select_country') }}</option>
                                @foreach ($countries as $country)
                                <option value="{{ $country->id }}" selected>{{ $country->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </fieldset>

                    <div class="box grid-2">
                        <fieldset>
                            <label for="governorates">{{ __('home.governorates') }}</label>
                            <div class="select-custom">
                                <select class="tf-select w-100 governorate" id="governorates" name="governorate_id" required data-default="">
                                    <option value="null">{{ __('home.select_governorate') }}</option>
                                    @foreach ($governorates as $governorate)
                                    <option value="{{ $governorate->id }}">{{ $governorate->name }}</option>
                                    @endforeach
                                </select>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="city">{{ __('home.Town/City') }}</label>
                            <input type="text" id="city" placeholder="{{ __('home.Town/City') }}" name="city" value="{{ old('city') }}" required>
                        </fieldset>
                    </div>



                    <fieldset class="box fieldset">
                        <label for="address">{{ __('home.Address') }}</label>
                        <input type="text" id="address" placeholder="{{ __('home.Address') }}" name="address" value="{{ old('address') }}" required>
                    </fieldset>

                    <fieldset class="box fieldset">
                        <label for="note">{{ __('home.Order notes (optional)') }}</label>
                        <textarea name="note" id="note">{{ old('note') }}</textarea>
                    </fieldset>

               
            </div>
            <div class="tf-page-cart-footer">
                <div class="tf-cart-footer-inner">
                    <h5 class="fw-5 mb_20">Your order</h5>
                    <div class="tf-page-cart-checkout widget-wrap-checkout">
                        <ul class="wrap-checkout-product">
                            @foreach($cart->items as $cartItem)
                            <li class="checkout-product-item">
                                <figure class="img-product">
                                    @if($cartItem->product_variant_id)
                                    <img src="{{$cartItem->variant->first_image }}" alt="{{ $cartItem->product->name }}">
                                    @else

                                    <img src="{{ $cartItem->product->main_image_path }}" alt="{{ $cartItem->product->name }}">
                                    @endif
                                    <span class="quantity">{{ $cartItem->quantity }}</span>
                                </figure>
                                <div class="content">
                                    <div class="info">
                                        <p class="name">{{ $cartItem->product->name }}</p>
                                        @if ($cartItem->variant)

                                        @foreach ($cartItem->variant->values as $value)
                                        <p><strong>{{ $value->value->attribute->name }}</strong>: {{ $value->value->value }}</p>
                                        @endforeach
                                        @endif
                                    </div>
                                    @if($cartItem->product->isOnSale($cartItem->product_variant_id))
                                    <div>
                                        <div class="sale-price">
                                            <strong>Now:</strong> {{ config('app.currency') }} {{
                                            $cartItem->product->getEffectivePrice($cartItem->product_variant_id) }}
                                        </div>
                                        <div class="original-price">
                                            <strong>Before sale price:</strong>
                                            <del>{{ config('app.currency') }} {{
                                                $cartItem->product->getOriginalPrice($cartItem->product_variant_id) }}</del>
                                        </div>
                                        <div class="save-discount">
                                            <strong>Save:</strong> {{ config('app.currency') }} {{
                                            $cartItem->product->getDiscountAmount($cartItem->product_variant_id) }}
                                        </div>
                                    </div>

                                    @else
                                    <span class="original-price">{{ config('app.currency') }} {{
                                        $cartItem->product->getOriginalPrice($cartItem->product_variant_id) }}</span>
                                    @endif
                                </div>
                            </li>
                            @endforeach
                        </ul>
                        {{-- <div class="coupon-box">
                            <input type="text" placeholder="Discount code">
                            <a href="#" class="tf-btn btn-sm radius-3 btn-fill btn-icon animate-hover-btn">Apply</a>
                        </div> --}}

                        <div class="d-flex justify-content-between line pb_20">
                            <h6 class="fw-5">{{ __('home.item_total') }}</h6>
                            <h6 class="total fw-5"> {{ config('app.currency') }} {{ $cart->total_price}}</h6>
                        </div>

                        @if( $cart->total_discounts > 0 )
                        <div class="d-flex justify-content-between line pb_20">
                            <h6 class="fw-5">{{ __('home.discounts') }}</h6>
                            <h6 class="total fw-5"> {{ config('app.currency') }} {{ $cart->total_discounts}}</h6>
                        </div>
                        @endif


                        <div class="d-flex justify-content-between line pb_20">
                            <h6 class="fw-5">{{ __('home.shipping') }}</h6>
                            @if(!$free_shipping)
                            <h6 class="shipping-fees fw-5"> {{ config('app.currency') }} {{ config('site_standard_shipping_fees') }}</h6>
                            @else
                            <del>
                                <h6 class="shipping-fees fw-5"> {{ config('app.currency') }} {{ config('site_standard_shipping_fees') }}</h6>
                            </del>
                            <h6 class="free-shipping">
                                {{ __('home.free_shipping') }}
                            </h6>
                            @endif

                        </div>

                      
                        <div class="d-flex justify-content-between line pb_20">
                            <h6 class="fw-5">{{ __('home.grand_total') }}</h6>
                            <h6 class="grand-total fw-5"> {{ config('app.currency') }} {{ $grand_total }}</h6>
                        </div>
                      


                        <div class="wd-check-payment">
                            @foreach ($payment_methods as $paymentMethod)
                            <div class="fieldset-radio mb_20">
                                <input type="radio" name="payment_method_id" value="{{ $paymentMethod->id }}" id="payment_method_{{ $paymentMethod->id }}" class="tf-check" checked>
                                <label for="payment_method_{{ $paymentMethod->id }}">{{ $paymentMethod->name }}</label>

                            </div>
                            @endforeach
                           
                        </div>
                        <button type="submit" class="tf-btn radius-3 btn-fill btn-icon animate-hover-btn justify-content-center">{{ __('home.place_order') }}</button>
                    </div>
                </div>
            </div>

        </form>
        </div>
    </div>
</section>
<!-- page-cart -->

@endsection
@section('script')
@if($errors->any())
<script>
    toastr.options = {
        "closeButton": true
        , "progressBar": true
        , "positionClass": "toast-top-right"
    };
    @foreach($errors -> all() as $error)
    toastr.error("{{$error}}");
    @endforeach

</script>

@endif
{{-- @include('website.scripts.events._begin_checkout_event',$cart ) --}}
@endsection
