@extends('layouts.app')
@section('content')
@section('meta')
@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@include('website._breadcrumb', ['page_title' => $category->name])
<!-- Section Product -->
<section class="flat-spacing-2">
    <div class="container">
        <div class="tf-shop-control grid-3 align-items-center">
            <div class="tf-control-filter">
                <a href="#filterShop" data-bs-toggle="offcanvas" aria-controls="offcanvasLeft" class="tf-btn-filter"><span class="icon icon-filter"></span><span class="text">Filter</span></a>
            </div>
            <ul class="tf-control-layout d-flex justify-content-center">

                <li class="tf-view-layout-switch sw-layout-2" data-value-layout="tf-col-2">
                    <div class="item"><span class="icon icon-grid-2"></span></div>
                </li>
                <li class="tf-view-layout-switch sw-layout-3" data-value-layout="tf-col-3">
                    <div class="item"><span class="icon icon-grid-3"></span></div>
                </li>
                <li class="tf-view-layout-switch sw-layout-4 active" data-value-layout="tf-col-4">
                    <div class="item"><span class="icon icon-grid-4"></span></div>
                </li>
                
            </ul>
            <div class="tf-control-sorting d-flex justify-content-end">
                <div class="tf-dropdown-sort" data-bs-toggle="dropdown">
                    <div class="btn-select">
                        <span class="text-sort-value">Featured</span>
                        <span class="icon icon-arrow-down"></span>
                    </div>
                    <div class="dropdown-menu">
                        <div class="select-item active">
                            <span class="text-value-item">Featured</span>
                        </div>
                        <div class="select-item">
                            <span class="text-value-item">Best selling</span>
                        </div>
                        <div class="select-item" data-sort-value="a-z">
                            <span class="text-value-item">Alphabetically, A-Z</span>
                        </div>
                        <div class="select-item" data-sort-value="z-a">
                            <span class="text-value-item">Alphabetically, Z-A</span>
                        </div>
                        <div class="select-item" data-sort-value="price-low-high">
                            <span class="text-value-item">Price, low to high</span>
                        </div>
                        <div class="select-item" data-sort-value="price-high-low">
                            <span class="text-value-item">Price, high to low</span>
                        </div>
                        <div class="select-item">
                            <span class="text-value-item">Date, old to new</span>
                        </div>
                        <div class="select-item">
                            <span class="text-value-item">Date, new to old</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-control-shop">
            <div class="meta-filter-shop">
                <div id="product-count-grid" class="count-text"></div>
                <div id="product-count-list" class="count-text"></div>
                <div id="applied-filters"></div>
                <button id="remove-all" class="remove-all-filters" style="display: none;">Remove All <i class="icon icon-close"></i></button>
            </div>

            <div class="tf-grid-layout wrapper-shop tf-col-4" id="gridLayout">

                <!-- card product  -->
                @forelse ($products as $product )
                    @include('website.home-partials.partials._product_card',['product'=>$product])
                @empty
                <p>No Products Avaliable for this category</p>
                @endforelse
                @if($products->count() > 0)
                <ul class="wg-pagination tf-pagination-list">
                    @if ($products->onFirstPage())
                    <li class="disabled"><span class="pagination-link">«</span></li>
                    @else
                    <li>
                        <a class="pagination-link animate-hover-btn" href="{{ $products->previousPageUrl() }}" rel="prev">«</a>
                    </li>
                    @endif

                    @foreach ($products->getUrlRange(1, $products->lastPage()) as $page => $url)
                    @if ($page == $products->currentPage())
                    <li class="active"><span class="pagination-link">{{ $page }}</span></li>
                    @else
                    <li>
                        <a class="pagination-link animate-hover-btn" href="{{ $url }}">{{ $page }}</a>
                    </li>
                    @endif
                    @endforeach

                    @if ($products->hasMorePages())
                    <li>
                        <a class="pagination-link animate-hover-btn" href="{{ $products->nextPageUrl() }}" rel="next">»</a>
                    </li>
                    @else
                    <li class="disabled"><span class="pagination-link">»</span></li>
                    @endif
                </ul>
                @endif

            </div>

        </div>
    </div>
</section>

@include('website.filter',['category' => $category, 'other_categories' => $other_categories, 'minPrice' => $minPrice, 'maxPrice' => $maxPrice, 'categoryColors' => $categoryColors])
@endsection

@section('script')
<script>
    // Select all checkboxes or radio buttons within the form
    const form = document.getElementById('facet-filter-form');

    $(document).ready(function() {
        $("form").on("change", "input:checkbox", function() {
            form.submit();
        });
    });



    // document.querySelector('select[name="sort_by"]').addEventListener('change', function() {
    //     form.submit();
    // });

</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const minRangeInput = document.querySelector('.range-min');
        const maxRangeInput = document.querySelector('.range-max');
        const form = document.getElementById('facet-filter-form');

        function updatePriceAndSubmit() {
            if (parseInt(minRangeInput.value) <= parseInt(maxRangeInput.value)) {
                form.submit();
            } else {
                alert('Minimum price should not exceed maximum price.');
            }
        }

        minRangeInput.addEventListener('change', updatePriceAndSubmit);
        maxRangeInput.addEventListener('change', updatePriceAndSubmit);
    });

</script>
@endsection