@extends('layouts.app')
@section('meta')
@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@section('content')
@include('website._breadcrumb', ['page_title' => $category->name ?? __('home.categories') ])
<section class="flat-spacing-2">
    <div class="container">

        <div class="wrapper-control-shop">
            <div class="tf-grid-layout wrapper-shop tf-col-4" id="gridLayout">
                @forelse ($categories as $category)
                <div class="swiper-slide">
                    <div class="collection-item-v2 hover-img">
                        <a href="{{ route('website.categories', $category->link) }}" class="collection-inner">
                            <div class="collection-image img-style">
                                <img class="lazyload" data-src="{{ $category->image_path }}" src="{{ $category->image_path }}" alt="{{ $category->name }}">
                            </div>
                            <div class="collection-content">
                                <div class="top wow fadeInUp" data-wow-delay="0s">
                                    <h5 class="heading">{{ $category->name }}</h5>

                                </div>
                                <div class="bottom wow fadeInUp" data-wow-delay="0s">
                                    <button class="tf-btn btn-line collection-other-link fw-6"><span>{{ __('home.shop_now') }}</span><i class="icon icon-arrow1-top-left"></i></button>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            
                @empty
                <p>{{ __('home.no_categories') }}</p>

                @endforelse



            </div>

        </div>
    </div>
</section>
@endsection
