@extends('layouts.app')
@section('meta')

@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@section('content')
{{-- Breadcrumb --}}
@include('website.product-partials._breadcrumb', ['page_title' => $blog->name])
<!-- blog-list -->
<div class="blog-detail">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="blog-list-main">
                    <div class="blog-detail-main-heading">
                        <div class="list-blog">
                            <div class="blog-detail-main-heading">
                                <div class="image">
                                    <img class="lazyload" data-src="{{ $blog->image_path }}" src="{{ $blog->image_path }}" alt="{{ $blog->name }}" />
                                </div>
                            </div>
                            <div class="blog-detail-content mt-3">
                                <div class="blog-detail-title">
                                    <h5>{{ $blog->name }}</h5>
                                </div>

                                <div class="blog-detail-text">
                                    <p>
                                       {!! $blog->content !!}
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <aside class="tf-section-sidebar wrap-sidebar-mobile">
                        <div class="sidebar-item sidebar-post">
                            <div class="sidebar-title">Recent Post</div>
                            <div class="sidebar-content">
                                <ul>
                                    @foreach ($other_blogs as $other_blog)
                                    <li>
                                        <div class="blog-article-item style-sidebar">
                                            <div class="article-thumb">
                                                <a href="{{ route('blog.details', $other_blog->id) }}">
                                                    <img src="{{ $other_blog->image_path }}" alt="{{ $other_blog->name }}" />
                                                </a>
                                            </div>
                                            <div class="article-content">
                                                <div class="article-label">
                                                    <a href="{{ route('blog.details', $other_blog->id) }}" class="tf-btn btn-sm radius-3 btn-fill animate-hover-btn">Accessories</a>
                                                </div>
                                                <div class="article-title">
                                                    <a href="{{ route('blog.details', $other_blog->id) }}" class="">{{ $other_blog->name }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </div>
    <div class="btn-sidebar-mobile">
        <button data-bs-toggle="offcanvas" data-bs-target="#sidebarmobile" aria-controls="offcanvasRight">
            <i class="icon-open"></i>
        </button>
    </div>
</div>
<!-- /blog-list -->
@endsection
