@extends('layouts.app')
@section('meta')
@php echo $metatags @endphp
@php echo $schema @endphp
@endsection
@section('content')

<!-- page-title -->
@include('website._breadcrumb',['page_title'=>__('home.about-us')])
<!-- /page-title -->

<!-- flat-title -->
<section class="flat-spacing-9">
    <div class="container">
        <div class="flat-title my-0">
            <span class="title">{{ $about->title }}</span>
            <p class="sub-title text_black-2">
                {!! $about->text !!}
            </p>
        </div>
    </div>
</section>
<!-- /flat-title -->

<div class="container">
    <div class="line"></div>
</div>

 <!-- image-text -->
 
@foreach ($about_structs as $about_struct)
@if ($loop->iteration % 2 == 1)
<section class="flat-spacing-23 flat-image-text-section">
    <div class="container">
        <div class="tf-grid-layout md-col-2 tf-img-with-text style-4">
            <div class="tf-image-wrap">
                <img class="lazyload w-100" data-src="{{ $about_struct->image_path }}"
                    src="{{ $about_struct->image_path }}" alt="{{ $about_struct->name }}">
            </div>
            <div class="tf-content-wrap px-0 d-flex justify-content-center w-100">
                <div>
                    <div class="heading">{{ $about_struct->name }}</div>
                    <div class="text">
                        {!! $about_struct->text !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@else
<section class="flat-spacing-15">
    <div class="container">
        <div class="tf-grid-layout md-col-2 tf-img-with-text style-4">
            <div class="tf-content-wrap px-0 d-flex justify-content-center w-100">
                <div>
                    <div class="heading">{{ $about_struct->name }}</div>
                    <div class="text">
                        {!! $about_struct->text !!}
                    </div>
                </div>
            </div>
            <div class="grid-img-group">
                <div class="tf-image-wrap box-img item-1">
                    <div class="img-style">
                        <img class="lazyload" src="{{ $about_struct->image_path }}"
                            data-src="{{ $about_struct->image_path }}" alt="{{ $about_struct->name }}">
                    </div>
                </div>
                <div class="tf-image-wrap box-img item-2">
                    <div class="img-style">
                        <img class="lazyload" src="{{ $about_struct->image_path }}"
                            data-src="{{ $about_struct->image_path }}" alt="{{ $about_struct->name }}">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /image-text -->
 <!-- Iconbox -->
 {{-- <section class="flat-spacing-27 bg_main-2">
    <div class="container">
        <div class="flat-title">
            <span class="title wow fadeInUp text-white text-center" data-wow-delay="0s">We’re solving the
                biggest problems in furniture</span>
        </div>
        <div class="wrap-carousel wrap-mobile flat-iconbox-v2 style-2 wow fadeInUp" data-wow-delay="0s">
            <div dir="ltr" class="swiper tf-sw-mobile-1" data-preview="1" data-space="15">
                <div class="swiper-wrapper wrap-iconbox">
                    <div class="swiper-slide">
                        <div class="tf-icon-box text-center">
                            <div class="icon">
                                <i class="icon-shipping-1 text-white"></i>
                            </div>
                            <div class="content">
                                <div class="title text-white">Fast & free shipping</div>
                                <p class="text-white">Every single order ships for free. No minimums, no tiers,
                                    no fine print whatsoever.</p>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="tf-icon-box text-center">
                            <div class="icon">
                                <i class="icon-payment-1 text-white"></i>
                            </div>
                            <div class="content">
                                <div class="title text-white">Modular, easy-to-move design</div>
                                <p class="text-white">Our innovative modular design is driven by the belief that
                                    furniture should fit this home, and the next one.</p>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-slide">
                        <div class="tf-icon-box text-center">
                            <div class="icon">
                                <i class="icon-return-1 text-white"></i>
                            </div>
                            <div class="content">
                                <div class="title text-white">Durable, premium materials</div>
                                <p class="text-white">We use materials like sustainably-forested wood,
                                    strengthened steel hardware, and top-grain Italian leather.</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <div class="sw-dots style-2 sw-pagination-mb-1 justify-content-center"></div>
        </div>
    </div>
</section> --}}
<!-- /Iconbox -->
@endif

@endforeach

@endsection
