@extends('layouts.admin')
@section('meta')
<title>
    {{ trans('home.add_slider') }}</title>

@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.sliders')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/sliders')}}">{{trans('home.sliders')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_slider')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.add_slider')}}</h6>
                    </div>
                    <form action="{{ route('sliders.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <input type="hidden" name="type" value="home">
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.title_en')}}</label>
                                <input class="form-control" name="title_en" type="text" placeholder="{{trans('home.title_en')}}" value="{{old('title_en')}}">
                            </div>
                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.title_ar')}}</label>
                                <input class="form-control" name="title_ar" type="text" placeholder="{{trans('home.title_ar')}}" value="{{old('title_ar')}}">
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.order')}}</label>
                                <input class="form-control" name="order" type="number" min="0" autocomplete="off" placeholder="{{trans('home.order')}}" value="{{old('order')}}">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="parent">{{trans('home.type')}}</label>
                                <select class="form-control select2 parent" name="type">
                                    <option value="home">Select Type</option>
                                    @foreach (App\Models\Slider::TYPES as $type)
                                        <option value="{{  $type }}">{{  $type }}</option>
                                        
                                    @endforeach
                                
                                

                                </select>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_en')}}</label>
                                <textarea class="area1" name="text_en">{{old('text_en')}}</textarea>

                            </div>
                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.text_ar')}}</label>
                                <textarea class="area1" name="text_ar">{{old('text_ar')}}</textarea>
                            </div>
                            <div class="form-group col-md-12">
                                <label class="">{{trans('home.link')}}</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">{{trans('home.link')}}</span>
                                    </div>
                                    <input type="text" class="form-control" name="link" placeholder="{{trans('home.link')}}" value="{{old('link')}}">
                                </div>
                            </div>
                            {{--  <div class="form-group col-md-12">
                                <label class="">{{trans('home.video_link')}}</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text">{{trans('home.video_link')}}</span>
                                    </div>
                                    <input type="text" class="form-control" name="video_link" placeholder="{{trans('home.video_link')}}" value="{{old('video_link')}}">
                                </div>
                            </div>  --}}

                            <div class="col-md-12">
                                <label>{{trans('home.image')}} (max 1mb, extension must .webp) </label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.upload')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="status" value="1" type="checkbox" value="{!! old('status')?? 1 !!}"><span class="tx-13">{{trans('home.publish')}}</span>
                                </label>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{trans('home.save')}} </button>
                                <a href="{{url('/admin/sliders')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>

                        </div>
                      
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

@endsection
