@extends('layouts.admin')
@section('meta')
<title>
    {{ trans('home.add_address') }}</title>

@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.addresses')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/site-addresses')}}">{{trans('home.address')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_address')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.add_address')}}</h6>
                    </div>
                    {!! Form::open(['route' => 'site-addresses.store', 'data-toggle'=>'validator', 'files'=>'true']) !!}
                    <div class="row">
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.title_en')}}</label>
                            <input class="form-control" name="title_en" type="text" placeholder="{{trans('home.title_en')}}" value="{{old('title_en')}}">
                        </div>
                        <div class="form-group col-md-4">
                            <label class="">{{trans('home.title_ar')}}</label>
                            <input class="form-control" name="title_ar" type="text" placeholder="{{trans('home.title_ar')}}" value="{{old('title_ar')}}">
                        </div>
                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.email')}}</label>
                            <input class="form-control" name="email" type="text" placeholder="{{trans('home.email')}}" value="{{old('email')}}">
                        </div>

                        <div class="form-group col-md-2">
                            <label class="">{{trans('home.order')}}</label>
                            <input class="form-control" name="order" type="number" min="0" autocomplete="off" placeholder="{{trans('home.order')}}" value="{{old('order')}}">
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.phone1')}}</label>
                            <input class="form-control" name="phone1" type="tel" min="0" autocomplete="off" placeholder="{{trans('home.phone1')}}" value="{{old('phone1')}}">
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.code1')}}</label>
                            <input class="form-control" name="code1" type="number" min="0" autocomplete="off" placeholder="{{trans('home.code1')}}" value="{{old('code1')}}">
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.phone2')}}</label>
                            <input class="form-control" name="phone2" type="number" min="0" autocomplete="off" placeholder="{{trans('home.phone2')}}" value="{{old('phone2')}}">
                        </div>
                        <div class="form-group col-md-3">
                            <label class="">{{trans('home.code2')}}</label>
                            <input class="form-control" name="code2" type="number" min="0" autocomplete="off" placeholder="{{trans('home.code2')}}" value="{{old('code2')}}">
                        </div>

                        <div class="form-group col-md-6">
                            <label class="">{{trans('home.address_en')}}</label>
                            <textarea class="form-control" name="address_en">{{old('address_en')}}</textarea>

                        </div>
                        <div class="form-group col-md-6">
                            <label class="">{{trans('home.address_ar')}}</label>
                            <textarea class="form-control" name="address_ar">{{old('address_ar')}}</textarea>
                        </div>
                        <div class="form-group col-md-12">
                            <label class="">{{trans('home.map_url')}}</label>
                            <textarea class="form-control" name="map_url">{{old('map_url')}}</textarea>
                        </div>

                        <div class="form-group col-md-12">
                            <label class="ckbox">
                                <input name="status" value="1" type="checkbox" value="{!! old('status')?? 1 !!}"><span class="tx-13">{{trans('home.publish')}}</span>
                            </label>
                        </div>

                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                {{trans('home.save')}} </button>
                            <a href="{{url('/admin/site-addresses')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                        </div>

                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

@endsection
