@extends('layouts.admin')
@section('meta')
<title>{{ trans('home.edit_setting') }}</title>
@endsection
@section('content')
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.edit_setting') }}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_setting') }}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    @if (session()->has('success'))
        <div class="alert alert-success">
            {{ session()->pull('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">

                    <div>
                        <h6 class="card-title mb-1">{{ trans('home.edit_setting') }}</h6>
                    </div>
               
                    <form action="{{ route('settings.update',$lang) }}" method="POST" enctype="multipart/form-data">

                        @csrf
                        @method('PATCH')
                        

                        <div class="row">
                            <div class="form-group col-md-3">
                                <label for="helperText">{{ trans('home.default_lang') }}</label>
                                <select class="form-control select2" name="lang" required>
                                    <option value="en" {{ config('site_lang') == 'en' ? 'selected' : '' }}>
                                        {{ trans('home.english') }}</option>
                                    <option value="ar" {{ config('site_lang') == 'ar' ? 'selected' : '' }}>
                                        {{ trans('home.arabic') }}</option>
                                </select>
                            </div>


                            <div class="form-group col-md-3">
                                <label class="">{{ trans('home.shipping_free_in') }}</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="free_amount" id="free_amount" class="form-control" value="{{ config('setting_free_amount') }}" aria-label="Text input with checkbox">
                                </div>
                            </div>

                            <div>
                                <label for="standard">{{ __('Standard Shipping Fees') }}</label>
                                <div class="input-group mb-3">
                                    <input type="text" name="standard_shipping_fees" id="standard_shipping_fees" class="form-control" value="{{ config('setting_standard_shipping_fees') }}" aria-label="Text input with checkbox">
                                </div>
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.contact_email') }}</label>
                                <input type="text" class="form-control" placeholder="{{ trans('home.contact_email') }}" name="contact_email" value="{{ config('setting_contact_email') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.telphone') }}</label>
                                <input type="number" min="0" class="form-control" placeholder="{{ trans('home.telephone') }}" name="telephone" value="{{ config('setting_telephone') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.email') }}</label>
                                <input type="text" class="form-control" placeholder="{{ trans('home.email') }}" name="email" value="{{ config('setting_email') }}">
                            </div>
                            
                            
                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.mobile') }}</label>
                                <input type="number" min="0" class="form-control" placeholder="{{ trans('home.mobile') }}" name="mobile" value="{{ config('setting_mobile') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.fax') }}</label>
                                <input type="text" min="0" class="form-control" placeholder="{{ trans('home.fax') }}" name="fax" value="{{ config('setting_fax') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.whatsapp') }}</label>
                                <input type="text"  class="form-control" placeholder="{{ trans('home.whatsapp') }}" name="whatsapp" value="{{ config('setting_whatsapp') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.snapchat') }}</label>
                                <input type="text"  class="form-control" placeholder="{{ trans('home.snapchat') }}" name="snapchat" value="{{ config('setting_snapchat') }}">
                            </div>
                            <div class="form-group col-md-2">
                                <label class="">{{ trans('home.tiktok') }}</label>
                                <input type="text"  class="form-control" placeholder="{{ trans('home.tiktok') }}" name="tiktok" value="{{ config('setting_tiktok') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="facebook">{{ trans('home.facebook') }}</label>
                                <input type="text" class="form-control" placeholder="{{ trans('home.facebook') }}" name="facebook" value="{{ config('setting_facebook') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="linkedin">{{ trans('home.linkedin') }}</label>
                                <input type="text" class="form-control" placeholder="{{ trans('home.linkedin') }}" name="linkedin" value="{{ config('setting_linkedin') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="instagram">{{ trans('home.instagram') }}</label>
                                <input type="text" class="form-control" placeholder="{{ trans('home.instagram') }}" name="instagram" value="{{ config('setting_instgram') }}">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="twitter">{{ trans('home.twitter') }}</label>
                                <input type="text" class="form-control" placeholder="{{ trans('home.twitter') }}" name="twitter" value="{{ config('setting_twitter') }}">
                            </div>


                            <div class="form-group col-md-12">
                                <label>{{ trans('home.map_url') }}</label>
                                <textarea class="form-control" name="map_url" type="text" placeholder="{{ trans('home.map_url') }}">{{ config('setting_map_url') }}</textarea>
                            </div>


                            <div class="form-group col-md-12 ">
                                <iframe src="{{ config('setting_map_url') }}" width="100%" height="250" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>


                            <div class="form-group col-md-12">
                                <label>{{ trans('gtm_script') }}</label>
                                <textarea class="form-control" name="gtm_script" type="text" placeholder="{{ trans('gtm_script') }}">{{ config('setting_gtm_script') }}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label>{{ trans('gtm_noscript') }}</label>
                                <textarea class="form-control" name="gtm_noscript" type="text" placeholder="{{ trans('gtm_noscript') }}">{{ config('setting_gtm_noscript') }}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{ trans('home.save') }} </button>
                                <a href="{{ url('/admin') }}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{ trans('home.cancel') }}</button></a>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>
@endsection
