@extends('layouts.admin')
<title>{{trans('home.seo_assistant')}}</title>
@section('content')

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.seo_assistant')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.seo_assistant')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    @if(session()->has('success'))
    <div class="alert alert-success">
        {{ session()->pull('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif

    <form action="{{ route('seo_assistant.update', $seo->id) }}" method="POST">
        @csrf
        @method('PATCH')
        <!-- Home Page Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.home_page')}}</h6>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="home_meta_title_en"> {{trans('home.meta_title_en')}}</label>
                                <textarea class="form-control" name="home_meta_title_en" placeholder="{{trans('home.meta_title_en')}}">{{$seo->home_meta_title_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="home_meta_desc_en"> {{trans('home.meta_desc_en')}}</label>
                                <textarea class="form-control" name="home_meta_desc_en" placeholder="{{trans('home.meta_desc_en')}}">{{$seo->home_meta_desc_en}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="home_meta_title_ar"> {{trans('home.meta_title_ar')}}</label>
                                <textarea class="form-control" name="home_meta_title_ar" placeholder="{{trans('home.meta_title_ar')}}">{{$seo->home_meta_title_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="home_meta_desc_ar"> {{trans('home.meta_desc_ar')}}</label>
                                <textarea class="form-control" name="home_meta_desc_ar" placeholder="{{trans('home.meta_desc_ar')}}">{{$seo->home_meta_desc_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="home_meta_robots" value="1" {{($seo->home_meta_robots == 1)?
                                    'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}} (index)</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Home Page   Row -->

        <!-- Categories Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.categories')}}</h6>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="categories_meta_title_en"> {{trans('home.meta_title_en')}}</label>
                                <textarea class="form-control" name="categories_meta_title_en" placeholder="{{trans('home.meta_title_en')}}">{{$seo->categories_meta_title_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="categories_meta_desc_en"> {{trans('home.meta_desc_en')}}</label>
                                <textarea class="form-control" name="categories_meta_desc_en" placeholder="{{trans('home.meta_desc_en')}}">{{$seo->categories_meta_desc_en}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="categories_meta_title_ar"> {{trans('home.meta_title_ar')}}</label>
                                <textarea class="form-control" name="categories_meta_title_ar" placeholder="{{trans('home.meta_title_ar')}}">{{$seo->categories_meta_title_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="categories_meta_desc_ar"> {{trans('home.meta_desc_ar')}}</label>
                                <textarea class="form-control" name="categories_meta_desc_ar" placeholder="{{trans('home.meta_desc_ar')}}">{{$seo->categories_meta_desc_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="categories_meta_robots" value="1" {{($seo->categories_meta_robots == 1)?
                                    'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}}
                                        (index)</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Categories Row -->

        <!-- Products Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.products')}}</h6>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="products_meta_title_en"> {{trans('home.meta_title_en')}}</label>
                                <textarea class="form-control" name="products_meta_title_en" placeholder="{{trans('home.meta_title_en')}}">{{$seo->products_meta_title_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="products_meta_desc_en"> {{trans('home.meta_desc_en')}}</label>
                                <textarea class="form-control" name="products_meta_desc_en" placeholder="{{trans('home.meta_desc_en')}}">{{$seo->products_meta_desc_en}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="products_meta_title_ar"> {{trans('home.meta_title_ar')}}</label>
                                <textarea class="form-control" name="products_meta_title_ar" placeholder="{{trans('home.meta_title_ar')}}">{{$seo->products_meta_title_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="products_meta_desc_ar"> {{trans('home.meta_desc_ar')}}</label>
                                <textarea class="form-control" name="products_meta_desc_ar" placeholder="{{trans('home.meta_desc_ar')}}">{{$seo->products_meta_desc_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="home_meta_robots" value="1" {{($seo->products_meta_robots == 1)?
                                    'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}}
                                        (index)</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Products Row -->

        <!-- Inspection Request Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.inspection_request')}}</h6>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inspection_request_meta_title_en"> {{trans('home.meta_title_en')}}</label>
                                <textarea class="form-control" name="inspection_request_meta_title_en" placeholder="{{trans('home.meta_title_en')}}">{{$seo->inspection_request_meta_title_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="inspection_request_meta_desc_en"> {{trans('home.meta_desc_en')}}</label>
                                <textarea class="form-control" name="inspection_request_meta_desc_en" placeholder="{{trans('home.meta_desc_en')}}">{{$seo->inspection_request_meta_desc_en}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="inspection_request_meta_title_ar"> {{trans('home.meta_title_ar')}}</label>
                                <textarea class="form-control" name="inspection_request_meta_title_ar" placeholder="{{trans('home.meta_title_ar')}}">{{$seo->inspection_request_meta_title_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="inspection_request_meta_desc_ar"> {{trans('home.meta_desc_ar')}}</label>
                                <textarea class="form-control" name="inspection_request_meta_desc_ar" placeholder="{{trans('home.meta_desc_ar')}}">{{$seo->inspection_request_meta_desc_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="inspection_request_meta_robots" value="1" {{($seo->inspection_request_meta_robots == 1)?
                                    'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}}
                                        (index)</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Inspection Request Row -->


        <!-- commercial Request Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.commercial_request')}}</h6>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="commercial_request_meta_title_en"> {{trans('home.meta_title_en')}}</label>
                                <textarea class="form-control" name="commercial_request_meta_title_en" placeholder="{{trans('home.meta_title_en')}}">{{$seo->commercial_request_meta_title_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="commercial_request_meta_desc_en"> {{trans('home.meta_desc_en')}}</label>
                                <textarea class="form-control" name="commercial_request_meta_desc_en" placeholder="{{trans('home.meta_desc_en')}}">{{$seo->commercial_request_meta_desc_en}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="commercial_request_meta_title_ar"> {{trans('home.meta_title_ar')}}</label>
                                <textarea class="form-control" name="commercial_request_meta_title_ar" placeholder="{{trans('home.meta_title_ar')}}">{{$seo->commercial_request_meta_title_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="commercial_request_meta_desc_ar"> {{trans('home.meta_desc_ar')}}</label>
                                <textarea class="form-control" name="commercial_request_meta_desc_ar" placeholder="{{trans('home.meta_desc_ar')}}">{{$seo->commercial_request_meta_desc_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="commercial_request_meta_robots" value="1" {{($seo->commercial_request_meta_robots == 1)?
                                    'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}}
                                        (index)</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End commercial Request Row -->

        <!-- Branches Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.branches')}}</h6>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="branches_meta_title_en"> {{trans('home.meta_title_en')}}</label>
                                <textarea class="form-control" name="branches_meta_title_en" placeholder="{{trans('home.meta_title_en')}}">{{$seo->branches_meta_title_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="branches_meta_desc_en"> {{trans('home.meta_desc_en')}}</label>
                                <textarea class="form-control" name="branches_meta_desc_en" placeholder="{{trans('home.meta_desc_en')}}">{{$seo->branches_meta_desc_en}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="branches_meta_title_ar"> {{trans('home.meta_title_ar')}}</label>
                                <textarea class="form-control" name="branches_meta_title_ar" placeholder="{{trans('home.meta_title_ar')}}">{{$seo->branches_meta_title_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="branches_meta_desc_ar"> {{trans('home.meta_desc_ar')}}</label>
                                <textarea class="form-control" name="branches_meta_desc_ar" placeholder="{{trans('home.meta_desc_ar')}}">{{$seo->branches_meta_desc_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="branches_meta_robots" value="1" {{($seo->branches_meta_robots == 1)?
                                    'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}}
                                        (index)</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Branches Row -->



        <!-- Contact Us Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.contact_us')}}</h6>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.en')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="contact_meta_title_en"> {{trans('home.meta_title_en')}}</label>
                                <textarea class="form-control" name="contact_meta_title_en" placeholder="{{trans('home.meta_title_en')}}">{{$seo->contact_meta_title_en}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="contact_meta_desc_en"> {{trans('home.meta_desc_en')}}</label>
                                <textarea class="form-control" name="contact_meta_desc_en" placeholder="{{trans('home.meta_desc_en')}}">{{$seo->contact_meta_desc_en}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <span class="badge badge-success">{{trans('home.ar')}}</span>
                                <hr>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="contact_meta_title_ar"> {{trans('home.meta_title_ar')}}</label>
                                <textarea class="form-control" name="contact_meta_title_ar" placeholder="{{trans('home.meta_title_ar')}}">{{$seo->contact_meta_title_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label for="contact_meta_desc_ar"> {{trans('home.meta_desc_ar')}}</label>
                                <textarea class="form-control" name="contact_meta_desc_ar" placeholder="{{trans('home.meta_desc_ar')}}">{{$seo->contact_meta_desc_ar}}</textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label class="ckbox">
                                    <input name="contact_meta_robots" value="1" {{($seo->contact_meta_robots == 1)?
                                    'checked':''}} type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}}
                                        (index)</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Products Row -->



        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{trans('home.save')}} </button>
                                <a href="{{url('/admin')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </form>
</div>
@endsection
