<div  class="row">
	<div class="col-lg-12">
		<div class="card custom-card">
			<div class="card-body">
				<div>
					<h6 class="card-title mb-1">{{trans('home.report_results')}}</h6>
					
					{{-- <p class="text-muted card-sub-title">{{trans('home.date_from')}} {{$dateFrom}}   {{trans('home.date_to')}}  {{$dateTo}}</p> --}}
				</div>
				
				<button type="button" id="exportBtn"  class="btn btn-secondary" data-url="{{ route('reports.orders.export') }}">{{trans('home.Export CSV')}}</button>
				

				<div class="table-responsive">
					@if(count($orders)>0)
						<table class="table table-hover mg-b-0">
							<thead>
                                <tr>
                                    <th>#</th>
                                    <th>{{ __('home.id') }}</th>
                                    <th>{{trans('home.order_number')}}</th>
                                    <th>{{trans('home.order_date')}}</th>
                                    <th>{{trans('home.order_user')}}</th>
                                    <th>{{ __('home.customer_status') }}</th>
                                    <th>{{ __('home.Email Address') }}</th>
                                    <th>{{trans('home.order_phone_numbers')}}</th>
                                    <th>{{ __('home.total') }}</th>
                                    <th>{{ __('home.products') }}</th>
                                    <th>{{trans('home.order_address')}}</th>
                                    <th>{{trans('home.order_status')}}</th>
                                    <th>{{trans('home.payment_status')}}</th>
                                    <th>{{trans('home.payment_method')}}</th>
                                    @can('delete_order')
                                    <th>Delete</th>
                                    @endcan
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($orders as $key=>$order)
                             
                                <tr>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{ $key+1}}</a></td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{$order->id}}</a></td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{$order->order_number}}</a></td>
                                    <td>{{date('Y-m-d', strtotime($order->created_at ))}}</td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{$order->user->f_name.' '.$order->user->l_name}}</a></td>
                                    <td>
                                        @if($order->is_first_order)
                                        <span class="badge badge-success">{{ __('home.first_time') }}</span>
                                        @else
                                        <span class="badge badge-warning">{{ __('home.repeat_customer') }}</span>
                                        @endif
                                        <br> <br>
                                        <small>{{ __('home.total_orders') }}: {{ $order->total_orders_by_phone }}</small>
                                    </td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{$order->user->email}}</a></td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{$order->address?->phone ?? trans('home.unknown_phone') }} </a></td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{$order->total_amount .' ' . config('app.currency') }} </a></td>
                                    <!-- NEW PRODUCTS COLUMN -->
                                    <td>
                                        @if($order->items && $order->items->count())
                                        @foreach($order->items as $item)
                                        <div>
                                            {{ $item->product->name }} (Qty: {{ $item->quantity }}, Price: {{ $item->product->price }})
                                        </div>
                                        @endforeach
                                        @else
                                        <span>{{ __('home.no_products') }}</span>
                                        @endif
                                    </td>

                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{$order->full_address ?? trans('home.unknown_address')}}</a></td>

                                    <td>
                                        @if($order->status_name == 'Pending')
                                        <span class="badge badge-primary">{{trans('home.pending')}}</span>
                                        @elseif($order->status_name == 'Processing')
                                        <span class="badge badge-secondary">{{trans('home.Processing')}}</span>
                                        @elseif($order->status_name == 'Confirmed')
                                        <span class="badge badge-info">{{trans('home.Confirmed')}}</span>
                                        @elseif($order->status_name == 'Shipped')
                                        <span class="badge badge-default">{{trans('home.Shipped')}}</span>
                                        @elseif($order->status_name == 'Out for Delivery')
                                        <span class="badge badge-success">{{trans('home.Out for Delivery')}}</span>
                                        @elseif($order->status_name == 'Delivered')
                                        <span class="badge badge-success">{{trans('home.delivered')}}</span>
                                        @elseif($order->status_name == 'Cancelled')
                                        <span class="badge badge-danger">{{trans('home.canceled')}}</span>
                                        @elseif($order->status_name == 'Refunded')
                                        <span class="badge badge-danger">{{trans('home.Refunded')}}</span>
                                        @elseif ($order->status_name == 'Failed')
                                        <span class="badge badge-danger">{{trans('home.Refunded')}}</span>
                                        @elseif ($order->status_name == 'On Hold')
                                        <span class="badge badge-danger">{{trans('home.On Hold')}}</span>
                                        @endif

                                    </td>
                                   
                                    @if($order->payment?->status == 'paid')
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{ __('home.paid')}} </a></td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{ $order->payment->paymentMethod?->name }}</a></td>
                                    @else
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{ __('home.unpaid')}} </a></td>
                                    <td><a href="{{ route('orders.edit', $order->id) }}">{{ $order->payment?->paymentMethod?->name }}</a></td>
                                    @endif

                                    @can('delete_order')
                                    <td>
                                        <form action="{{ route('orders.destroy',$order->id) }}" method="POST">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm delete" data-toggle="modal" data-target="#deleteModal"><i class="fas fa-trash"></i></button>
                                        </form>
                                    </td>
                                    @endcan
                                </tr>
                                @endforeach
                            </tbody>
						</table>
					@else
                        <div class="text-center">
                            <h3>{{trans('home.no_data_found')}}</h3>
                        </div>
                    @endif	
				</div>
			</div>
		</div>
	</div>
</div>
