@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.variants') }}</title>
@endsection
@section('content')
    <div class="spainer"></div>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.variants') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ url('/admin') }}"> {{ trans('home.admin') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ url('admin/products') }}">{{ trans('home.products') }} </a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{ url('admin/products/' . $product->id.'/edit') }}">{{ $product->name }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.variants') }}</li>
                </ol>
            </div>

        </div>
      @include('admin.products.variants.create')
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.variants') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}
                            </p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>

                                        <th>#</th>
                                        <th>{{ __('home.id') }}</th>
                                        {{--  <th>{{ __('home.attribute') }}</th>  --}}
                                        <th>{{ trans('home.values') }}</th>
                                        <th>{{ trans('home.price') }}</th>
                                        <th>{{ trans('home.stock') }}</th>
                                        <th>{{ trans('home.edit') }}</th>
                                        <th>{{ __('home.images') }}</th>
                                        <th>{{ trans('home.delete') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($product->variants as $key => $variant)
                                        <tr id="variant_{{ $variant->id }}">
                                            <td>{{ $key + 1 }}</td>
                                            <td>{{ $variant->id }}</td>
                                            {{--  <td>{{ $variant->value->attribute->name }}</td>  --}}

                                                <td>
                                                      @foreach ($variant->values as $variantValue)
                                                    <span class="badge badge-primary">{{ $variantValue->value->value }}</span>
                                                       @endforeach
                                                </td>



                                            <td>{{ $variant->additional_price }}</td>
                                            <td>{{ $variant->stock }}</td>

                                            <td>
                                                    <button type="button" class="btn btn-info" data-toggle="modal" data-target="#variantForm_{{ $variant->id }}">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                            </td>
                                            <td>
                                                <a href="{{ route('variants.images.index', [$variant->id]) }}" class="btn btn-primary">
                                                    <i class="fas fa-image"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <form action="{{ route('products.variants.destroy', [$product->id, $variant->id]) }}" method="POST"  class="delete-form">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-delete-form">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Update-->
        @foreach ($product->variants as $variant)
            <div class="modal fade text-left" id="variantForm_{{ $variant->id }}" tabindex="-1" role="dialog"
                aria-labelledby="variantEditModal{{ $variant->id }}" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3 class="modal-title" id="variantEditModal{{ $variant->id }}">{{ trans('home.edit_product_varinats') }}</h3>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                       @include('admin.products.variants.update')

                    </div>
                </div>
            </div>
        @endforeach

         <!-- End Row -->

    </div>
    @endsection
