@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.discounts') }}</title>
@endsection
@section('content')
    <div class="spainer"></div>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.discounts') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="{{ url('/admin') }}"> {{ trans('home.admin') }}</a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="{{ url('admin/products') }}">{{ trans('home.products') }} </a>
                    </li>
                    <li class="breadcrumb-item"><a href="{{ url('admin/products/' . $product->id.'/edit') }}">{{ $product->name }}</a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.discounts') }}</li>
                </ol>
            </div>
        </div>
      @include('admin.products.discounts.create')
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{ trans('home.products') }}</h6>
                            <p class="text-muted card-sub-title">
                                {{ trans('home.table_contain_all_data_shortly_you_can_view_more_details') }}
                            </p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>

                                        <th>#</th>
                                        <th class="wd-20p">{{ trans('home.name') }}</th>
                                        <th  class="wd-20p">{{ __('home.variant') }}</th>
                                        <th class="wd-20p">{{ trans('home.type') }}</th>
                                        <th class="wd-20p">{{ trans('home.value') }}</th>
                                        <th class="wd-20p">{{ trans('home.starts_at') }}</th>
                                        <th class="wd-25p">{{ trans('home.expires_at') }}</th>
                                        <th class="wd-20p">{{ trans('home.status') }}</th>
                                        <th class="wd-20p">{{ trans('home.edit') }}</th>
                                        <th class="wd-20p">{{ trans('home.edit') }}</th>
                                    </tr>
                                </thead>
                                <tbody>


                                    @foreach ($discounts as $key => $discount)

                                        <tr >
                                            <td> {{ $key + 1 }} </td>
                                            <td> {{ $discount->name }}  </td>
                                            <td>
                                                @if($discount->variant)
                                                @foreach ($discount->variant->values as $variantValue)
                                                <span class="badge badge-primary">{{ $variantValue->value->value }}</span>
                                               @endforeach
                                                @endif

                                            </td>
                                            <td> {{ $discount->type }}  </td>
                                            <td> {{ $discount->value }}  </td>
                                            <td> {{ $discount->starts_at }}  </td>
                                            <td> {{ $discount->expires_at }}  </td>
                                            <td  class="{{$discount->is_active ? 'bg-success' : '' }}"> {{ $discount->is_active  ? 'active' : 'Not Active' }} </td>
                                            <td>
                                                <a href="{{ route('products.discounts.edit', [$product->id, $discount->id]) }}" class="btn btn-info">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <form action="{{ route('products.discounts.destroy', [$product->id, $discount->id]) }}" method="POST"  class="delete-form">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-delete-form">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

