@extends('layouts.admin')
@section('meta')
<title>{{trans('home.add_partner')}}</title>
@endsection
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.partners')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{ route('partners.index')}}">{{trans('home.partners')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_partner')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.add_partner')}}</h6>
                    </div>
                    <form action="{{ route('partners.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="row">

                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name_en')}}</label>
                                <input class="form-control" name="name_en" type="text" value="{{old('name_en')}}"
                                    placeholder="{{trans('home.name_en')}}" required>
                            </div>

                            <div class="form-group col-md-3">
                                <label class="">{{trans('home.name_ar')}}</label>
                                <input class="form-control" name="name_ar" type="text" value="{{old('name_ar')}}"
                                    placeholder="{{trans('home.name_ar')}}">
                            </div>

                            <div class="form-group col-md-2">
                                <label class="">{{trans('home.order')}}</label>
                                <input class="form-control" name="order" value="{{old('order')}}" type="number"
                                    value="1" min="1" placeholder="{{trans('home.order')}}" />
                            </div>

                            <div class="col-md-3">
                                <label>{{trans('home.logo')}} (225px * 225px max 1mb)</label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{trans('home.logo')}}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="logo">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{trans('home.choose_logo')}}</label>
                                    </div>
                                </div>
                            </div>


                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.short_desc_en')}}</label>
                                <textarea class="form-control area1" name="short_desc_en" type="text"
                                    placeholder="{{trans('home.short_desc_en')}}">{!! old('short_desc_en') !!}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.short_desc_ar')}}</label>
                                <textarea class="form-control area1" name="short_desc_ar" type="text"
                                    placeholder="{{trans('home.short_desc_ar')}}">{!! old('short_desc_ar') !!}</textarea>
                            </div>


                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.description_en')}}</label>
                                <textarea class="form-control area1" name="description_en" type="text"
                                    placeholder="{{trans('home.description_en')}}">{!! old('description_en') !!}</textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class="">{{trans('home.description_ar')}}</label>
                                <textarea class="form-control area1" name="description_ar" type="text"
                                    placeholder="{{trans('home.description_ar')}}">{!! old('description_ar') !!}</textarea>
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{trans('home.website')}}</label>
                                <input class="form-control" name="website" value="{{old('website')}}" type="text"
                                    placeholder="{{trans('home.website')}}" />
                            </div>

                            <div class="form-group col-md-4">
                                <label for="name_ar">{{trans('home.slug_en')}}</label>
                                <input type="text" autocomplete="off" class="form-control"
                                    placeholder="{{trans('home.slug_en')}}" name="slug_en" value="{{old('slug_en') }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label>{{trans('home.slug_ar')}}</label>
                                <input type="text" autocomplete="off" class="form-control"
                                    placeholder="{{trans('home.slug_ar')}}" name="slug_ar" value="{{old('slug_ar') }}">
                            </div>

                            <div class="form-group col-md-4">
                                <label class="ckbox">
                                    <input name="status" value="1"  value="{{ old('status') }}" checked type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                </label>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    {{trans('home.save')}} </button>
                                <a href="{{ route('partners.index')}}"><button type="button"
                                        class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                        {{trans('home.cancel')}}</button></a>
                            </div>

                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

@endsection