@extends('layouts.admin')
<title>{{trans('home.order_details')}}</title>
@section('style')
<style type="text/css">
    #loader {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        width: 100%;
        background: rgba(0, 0, 0, 0.75) url(https://mix-cosmetic.com/resources/assets/back/img/loader.gif) no-repeat center center;
        z-index: 10000;
    }

</style>
@endsection
@section('content')

<div id="loader"></div>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.order_details')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/orders')}}">{{trans('home.orders')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{trans('home.order_details')}}</li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    @if(session()->has('success'))
    <div class="alert alert-success">
        {{ session()->pull('success') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif

    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">

                    <div aria-multiselectable="true" class="accordion" id="accordion" role="tablist">
                        <div class="card">
                            <div class="card-header" id="headingOne" role="tab">
                                <a aria-controls="collapseOne" aria-expanded="true" data-toggle="collapse" href="#collapseOne" class="collapsed">{{trans('home.order_details')}}</a>
                            </div>
                            <div aria-labelledby="headingOne" class="collapse show" data-parent="#accordion" id="collapseOne" role="tabpanel" style="">
                                <div class="card-body">
                                    <div class="order_details">
                                        <div class="row">
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.tracking_code')}} :</strong>
                                                    {{$order->order_number}}</p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.order_date')}} :</strong> {{date('Y-m-d',
                                                    strtotime($order->created_at ))}}</p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.address')}} :</strong> {{$order->address->full_address}}
                                                </p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{__('home.order_user')}} :</strong> {{$order->user->name}}
                                                </p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{__('home.Email Address')}} :</strong>
                                                    {{$order->user->email}}</p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{__('home.order_phone_numbers')}} :</strong>
                                                    {{$order->address?->phone}}</p>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.products_price')}} :</strong>
                                                   {{ config('app.currency') }}  {{$order->totalProductsPrice() ?? 0}} </p>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.payment_method')}} :</strong> {{
                                                    $order->paymentMethod?->name}}</p>
                                            </div>
                                          
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.shipping_fees')}} :</strong>
                                                    {{ config('app.currency') }}  {{$order->shipping_fees ?? 0}}</p>
                                            </div>
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.payment')}} :</strong>
                                                    {{$order->payment->name}}</p>
                                            </div>

                                         
                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.total')}} :</strong> {{ config('app.currency') }}  {{$order->total_amount}} </p>
                                            </div>

                                            <div class="col-sm-12 col-md-6">
                                                <p><strong>{{trans('home.order_note')}} :</strong> {{$order->note}}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                   
                                    <div class="table-responsive-sm order-table">
                                        <table class="bg-white table table-bordered table-hover text-center">
                                            <thead>
                                                <tr>
                                                    <th class="text-left">Product Image</th>
                                                    <th class="text-left">Product Name</th>
                                                    <th class="text-left">Product Description</th>
                                                    <th class="text-left">{{ trans('home.quantity') }}</th>
                                                    <th class="text-left">Unit Price </th>
                                                    <th class="text-left">{{trans('home.discount')}}</th>
                                                    <th class="text-left">Total Price</th>  
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($order->items as $item)
                                                <tr>
                                                    <td>
                                                        <a href="{{ route('product.details' , $item->product->id) }}" class="thumb">
                                                            @if($item->product_variant_id)
                                                            <img width="60px" class="checkout-image" src="{{ $item->product->defaultVariant->first_image  }}">
                                                            @else
                                                            <img width="60px" class="checkout-image" src="{{  $item->product->main_image_path }}">

                                                            @endif
                                                        </a>
                                                    </td>
                                                    <td class="text-left">
                                                        <a href="{{ route('product.details' , $item->product->id) }}" class="thumb">
                                                            {{ $item->product->name}}
                                                        </a>
                                                         {{-- Variant Attributes --}}
                                                        @if ($item->product_variant_id)
                                                        
                                                        @foreach ($item->variant->values as $value)
                                                        <p>{{ $value->value->attribute->name }} : {{ $value->value->value }}</p>
                                                        @endforeach
                                                        @endif
                                                    </td>
                                                    <td>{{ $item->product->short_text}}</td>
                                                    <td>{{$item->quantity}}</td>
                                                    <td>{{$item->price}}</td>

                                                    <td>{{$item->product->getDiscountAmount($item->product_variant_id)}}</td>

                                                    <td>{{ $item->total_price}}</td>
                                                    
                                                </tr>

                                                @empty
                                                <tr>
                                                    <td colspan="5">{{trans('home.order_item_not_availbale_now')}}</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>

                    <div>
                        <h6 class="card-title mb-1">{{trans('home.order_shipment')}}</h6>
                    </div>

                    <div class="form-wizard-steps order-tracking">

                        <div class="form-wizard-progress">
                            <div class="form-wizard-progress-line" data-now-value="12.25" data-number-of-steps="4" style="width: 12.25%;"></div>
                        </div>

                        @php
                        $iconMap = [
                            'Pending'   => 'fa-unlock-alt',
                            'Shipped'   => 'fa-check',
                            'In Transit'=> 'fa-recycle',
                            'Delivered' => 'fa-shipping-fast',
                            'Returned'  => 'fa-undo',
                            'Cancelled' => 'fa-times',
                        ];
                    @endphp
                   
                    @foreach($order_shipment_statuses as $order_shipment_status)
                        @php
                            $statusName = $order_shipment_status->name;
                            $isCurrent = $order->status_current === $statusName;
                            $btnClass = $isCurrent ? 'btn-success' : 'btn-primary';
                            $iconClass = $iconMap[$statusName] ?? 'fa-handshake';
                            $imgSrc = url('resources/assets/back/img/' . ($statusImages[$statusName] ?? 'box.png'));
                        @endphp
                    
                        <div class="step-track">
                            <div class="step-icon">
                                <button type="button" class="btn track-order {{ $btnClass }}" data-status="{{ $statusName }}">
                                    <img style="display:none;" src="{{ $imgSrc }}">
                                    <i class="fa {{ $iconClass }}"></i>
                                </button>
                            </div>
                            <p>{{ $statusName }}</p>
                        </div>
                    @endforeach

                    </div>

                    {{-- Status Change Modal --}}
                    <div class="modal fade" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <form id="statusForm">
                                @csrf
                                <input type="hidden" name="orderId" value="{{ $order->id }}">
                                <input type="hidden" name="status" id="statusInput">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="statusModalLabel">{{ trans('home.add_comment') }}
                                        </h5>
                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="form-group">
                                            <label for="note">{{ trans('home.comment') }}</label>
                                            <textarea name="note" id="noteInput" class="form-control" rows="3" placeholder="{{ trans('home.write_your_comment') }}"></textarea>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary">{{ trans('home.submit')
                                            }}</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <br>
                    {{-- <div class="table-responsive">
                        <table class="table mg-b-0">
                            <thead>
                                <tr>
                                    <th>{{trans('home.date')}}</th>
                                    <th>{{trans('home.time')}}</th>
                                    <th>{{trans('home.status')}}</th>
                                    <th>{{trans('home.note')}}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($order->orderStatus as $status)
                                <tr>
                                    <th scope="row">{{date('Y/m/d', strtotime($status->created_at ))}}</th>
                                    <td>{{date('h:i:s', strtotime($status->created_at ))}}</td>
                                    <td>{{trans("home.$status->status")}}</td>
                                    <td>{{$status->note}}</td>
                                </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div> --}}

                </div>

                {{-- <div class="card-footer text-right">
                    <a href="{{url('admin/order/'.$order->id.'/invoice')}}" target="_blank">
                        <button type="button" class="btn ripple btn-primary mb-1"><i class="fe fe-credit-card mr-1"></i>{{trans('home.generate_invoice')}}</button>
                    </a>
                </div> --}}
                {{-- <div class="card-footer text-left">
                    <form @if( 'canceled' !=$order->orderStatus->toArray())
                        action="{{url('admin/orders/changeStatus')}}" method="POST" @endif>
                        @csrf
                        <div class="input-group mb-3">
                            <input type="hidden" name="status" value="canceled">
                            <input type="hidden" name="orderId" value="{{$order->id}}">

                            <button @if('canceled'==$order->status_current) disabled @endif class="btn
                                btn-outline-secondary" type="submit"
                                id="button-addon1">{{trans('home.cancel_order')}}</button>

                            <input type="text" @readonly($order->status_current == 'canceled') class="form-control"
                            placeholder="" value="{{$order->status_current_not}}" name="note" aria-label="Example text
                            with button addon" aria-describedby="button-addon1">
                            <input type="text" @readonly($order->status_current == 'canceled') class="form-control"
                            placeholder=""  name="note" aria-label="Example text
                            with button addon" aria-describedby="button-addon1">
                        </div>
                    </form>
                </div> --}}
            </div>
        </div>
    </div>

    {{-- <div class="row">
        <div class="col-lg-12">
            <div class="card custom-card">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.select_order_delivery')}}</h6>
                    </div>
                    <form action="{{url('admin/order/delivery/'.$order->id)}}" method="POST">
                        @csrf
                        <div class="row align-items-center">

                            <div class="form-group col-md-5">
                                <label for="code">{{trans('home.delivery_date')}}</label>
                                <div class="input-group">
                                    <input type='text' class="form-control dateFrom" value="{{$order->delivery_date}}" placeholder="{{trans('home.delivery_date')}}" id="datepicker1" name="delivery_date" readonly required />
                                    <div class="input-group-append">
                                        <span class="input-group-text">
                                            <i class="fas fa-calendar"></i>
                                        </span>
                                    </div>
                                </div>
                            </div>


                             <div class="form-group col-md-5">
                                <label for="helperText">{{trans('home.deliver_man')}}</label>
                            <select class="form-control select2" name="delivery_id" required>
                                <option></option>
                                @foreach($deliveries as $delivery)
                                <option value="{{$delivery->id}}" {{($delivery->id == $order->delivery_id
                                        )?'selected':''}}>{{$delivery->name}} - {{$delivery->phone1}}</option>
                                @endforeach

                            </select>
                        </div> 

                         @if(! $order->delivery_id )
                            <div class="form-group col-md-2">
                                <button type="submit" class="btn btn-success" style="margin-top: 25px"><i
                                        class="icon-note"></i> {{trans('home.save')}} </button>
                </div>
                @endif 
            </div>
            </form>
        </div>

    </div> --}}
</div>
</div>
</div>

@endsection

@section('script')
<script>
    $(document).on({
        ajaxStart: function() {
            $('#loader').show();
        }
        , ajaxStop: function() {
            $('#loader').hide();
        }
    });

    $('.track-order').on('click', function() {
        var status = $(this).data('status');
        $('#statusInput').val(status);
        $('#noteInput').val('');
        $('#statusModal').modal('show');
    });

    $('#statusForm').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();

        $.ajax({
            url: "{{ url('admin/orders/changeStatus') }}"
            , method: 'POST'
            , data: formData
            , success: function() {
                $('#statusModal').modal('hide');
                location.reload();
            }
            , error: function(xhr) {
                if (xhr.responseJSON && xhr.responseJSON.message) {
                    alert(xhr.responseJSON.message);
                } else {
                    alert('{{ trans("home.error_occurred") }}');
                }
            }
        });
    });

    $("#datepicker1").datepicker({
        changeMonth: true
        , changeYear: true
        , dateFormat: 'yy-mm-dd'
    });

</script>
@endsection
