@extends('layouts.admin')
<title>{{trans('home.add_branche')}}</title>
@section('content')

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.branches')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('branches.index') }}">{{trans('home.branches')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_branche')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.add_branche')}}</h6>
                        </div>
                        <form action="{{ route('branches.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.name_en')}}</label>
                                    <input class="form-control" name="name_en" type="text" placeholder="{{trans('home.name_en')}}">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.name_ar')}}</label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="{{trans('home.name_ar')}}">
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.address_en')}}</label>
                                    <input class="form-control" name="address_en" type="text" placeholder="{{trans('home.address_en')}}" />
                                </div>

                                <div class="form-group col-md-6">
                                    <label class="">{{trans('home.address_ar')}}</label>
                                    <input class="form-control" name="address_ar" type="text" placeholder="{{trans('home.address_ar')}}"/>
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="inputName4">{{trans('home.governorates')}}:</label>
                                    <select class="form-control Governorate select2" name="governorate_id">
                                        <option value="null">{{ __('home.select_governorate') }}</option>
                                        @foreach($governorates as $governorate)
                                            <option value="{{$governorate->id}}"> {{ $governorate->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                
                                <div class="form-group col-md-3">
                                    <label class="">{{trans('home.phone')}}</label>
                                    <input class="form-control" name="phone" type="number" min="0" placeholder="{{trans('home.phone')}}">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class="">{{trans('home.phone')}} 2</label>
                                    <input class="form-control" name="phone2" type="number" min="0" placeholder="{{trans('home.phone')}} 2">
                                </div>

                                <div class="form-group col-md-3">
                                    <label class="">{{trans('home.telephone')}}</label>
                                    <input class="form-control" name="telephone" type="number" min="0" placeholder="{{trans('home.telephone')}}">
                                </div>
                                
                                <div class="col-md-12">
                                    <label>{{trans('home.map_url')}}</label>
                                    <textarea class="form-control" name="map_url" type="text" placeholder="{{trans('home.map_url')}}"></textarea>
                                </div>

                                <div class="form-group col-md-12 mt-3">
                                    <label class="ckbox">
                                        <input name="status" value="1" type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{ route('branches.index') }}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>
                                
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection

@section('script')
    <script>
        $('.Governorate').select2({
            'placeholder':'{{trans("home.Governorates")}}'
        });

        $('.area').select2({
            'placeholder':'{{trans("home.areas")}}'
        });

        $('.Governorate').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '{{url('getAreas')  }}',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'">@if(\App::getLocale() == 'en')'+ data[i].name_en +' @else '+ data[i].name_ar +' @endif</option>';
                    }
                    area.html(html);
                }
            });
        });
    
    </script>
@endsection