@extends('layouts.admin')
@section('meta')
<title>{{__('home.add_blog_item')}}</title>
@endsection
@section('content')

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.blogItems')}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item"><a href="{{url('admin/blog-items')}}">{{trans('home.blogItems')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.add_blog_item')}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{trans('home.add_blog_item')}}</h6>
                        </div>
                       <form action="{{ route('blogs.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="row">

                                <div class="form-group col-md-4">
                                    <label for="name_en">{{trans('home.name_en')}}</label>
                                    <input type="text"  class="form-control" placeholder="{{trans('home.name_en')}}" name="name_en" required>
                                </div>

                                <div class="form-group col-md-4">
                                    <label for="name_ar">{{trans('home.name_ar')}}</label>
                                    <input type="text"  class="form-control" placeholder="{{trans('home.name_ar')}}" name="name_ar" required>
                                </div>
                                
                                <div class="form-group col-md-4">
                                    <label for="author">{{trans('home.author')}}</label>
                                    <input type="text" class="form-control" placeholder="{{trans('home.author')}}" name="author" >
                                </div>

                                <div class="form-group col-md-4">
                                    <label>{{trans('home.image')}}</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> {{trans('home.upload')}}</span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                        </div>
                                    </div>
                                </div>


                                <div class="form-group col-md-4">
                                    <label for="code">{{trans('home.date')}}</label>
                                    <div class="input-group">
                                        <input type='text' class="form-control" name="date" placeholder="{{trans('home.date')}}" id="datepicker"   />
                                        <div class="input-group-append">
                                            <span class="input-group-text">
                                                <i class="fas fa-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-6 ">
                                    <label for="short_content_en">{{trans('home.short_content_en')}}</label>
                                    <textarea class="form-control " name="short_content_en" placeholder="{{trans('home.short_content_en')}}" ></textarea>
                                </div>

                                <div class="form-group col-md-6 ">
                                    <label for="short_content_ar">{{trans('home.short_content_ar')}}</label>
                                    <textarea class="form-control " name="short_content_ar" placeholder="{{trans('home.short_content_ar')}}" ></textarea>
                                </div>

                                <div class="form-group col-md-6 ">
                                    <label for="content_en">{{trans('home.content_en')}}</label>
                                    <textarea class="form-control area1" name="content_en" placeholder="{{trans('home.content_en')}}" ></textarea>
                                </div>

                                <div class="form-group col-md-6 ">
                                    <label for="content_ar">{{trans('home.content_ar')}}</label>
                                    <textarea class="form-control area1" name="content_ar" placeholder="{{trans('home.content_ar')}}" ></textarea>
                                </div>


                                <div class="form-group col-md-6">
                                    <label class="ckbox">
                                        <input name="status" value="1" type="checkbox"><span class="tx-13">{{trans('home.publish')}}</span>
                                    </label>
                                </div>

         

                                <div class="form-group col-md-6">
                                    <label class="ckbox">
                                        <input name="show_in_home" value="1" type="checkbox"><span class="tx-13">{{trans('home.show_in_home')}}</span>
                                    </label>
                                </div>

                                <div class="col-12">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success">{{trans('home.en')}}</span>
                                        </div>
                                        <div class="form-group col-md-2">
                                            <label for="link_en">{{trans('home.link_en')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.link_en')}}" name="slug_en">
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                            <textarea class="form-control" name="meta_title_en" placeholder="{{trans('home.meta_title')}}"></textarea>
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                            <textarea class="form-control" name="meta_description_en" placeholder="{{trans('home.meta_desc')}}"></textarea>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success">{{trans('home.ar')}}</span>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label for="link_ar">{{trans('home.link_ar')}}</label>
                                            <input type="text"  class="form-control" placeholder="{{trans('home.link_ar')}}" name="slug_ar">
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> {{trans('home.meta_title')}}</label>
                                            <textarea class="form-control" name="meta_title_ar" placeholder="{{trans('home.meta_title')}}"></textarea>
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> {{trans('home.meta_desc')}}</label>
                                            <textarea class="form-control" name="meta_description_ar" placeholder="{{trans('home.meta_desc')}}"></textarea>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <label class="ckbox">
                                                <input name="meta_robots" value="1" type="checkbox"><span class="tx-13">{{trans('home.meta_robots')}} (index)</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="image-note"></i> {{trans('home.save')}} </button>
                                    <a href="{{ route('blogs.index') }}"><button type="button" class="btn btn-danger mr-1"><i class="image-trash"></i> {{trans('home.cancel')}}</button></a>
                                </div>

                            </div>
                       </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection


@section('script')
    <script>

        $( "#datepicker" ).datepicker({
            changeMonth: true,
            changeYear: true,
            dateFormat: 'yy-mm-dd'
        });
    </script>
@endsection
