@extends('layouts.admin')
<title>{{ $attribute->name }} {{ __('home.values') }}</title>
@section('content')

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.attributes_values')}}</h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                <li class="breadcrumb-item"><a href="{{url('admin/attributes')}}">{{trans('home.attributes')}}</a></li>
                <li class="breadcrumb-item active" aria-current="page">{{ $attribute->name }} {{ __('home.values') }}</li>
            </ol>
        </div>
    </div>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1">{{trans('home.add_attribute_values')}}</h6>
                    </div>
                    <form action="{{ route('attributes.values.store',[$attribute->id]) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="border">

                            <form action="{{ route('attributes.values.store',[$attribute->id]) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="row">

                                    <div class="form-group col-md-4">
                                        <label class="">{{__('home.value_ar')}}</label>
                                        <input class="form-control" name="value_ar" type="text" value="{{old('value_ar')}}" placeholder="{{__('home.value_ar')}}">
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label class="">{{__('home.value_en')}}</label>
                                        <input class="form-control" name="value_en" type="text" value="{{old('value_en')}}" placeholder="{{__('home.value_en')}}">
                                    </div>

                                    @if($attribute->isColor())
                                    <div class="form-group col-md-2">
                                        <label class="">{{__('home.code')}}</label>
                                        <input type="color" class="form-control" name="code" type="text" placeholder="{{__('home.code')}}">
                                    </div>
                                    @endif

                                    <div class="form-group col-md-2">
                                        <div class="d-flex flex-wrap gap-2">

                                            <h5 class="font-size-14 mb-3">{{__('home.publish/unpublish')}} </h5>

                                            <input type="checkbox" id="switch1" switch="none" value="1" name="status" checked />
                                            <label for="switch1" data-on-label="{{ __('home.yes') }}" data-off-label="{{ __('home.no') }}"></label>
                                        </div>
                                    </div>


                                    <div class="form-group col-md-12">
                                        <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                            {{ __('Save changes') }} </button>
                                        <a href="{{ route('attributes.edit',[$attribute->id]) }}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                                {{__('home.cancel')}}</button></a>
                                    </div>

                                </div>
                            </form>

                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
