@extends('layouts.admin')
@section('meta')
    <title>{{ trans('home.edit_about') }}</title>
@endsection
@section('content')
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{ trans('home.about') }}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ url('/admin') }}">{{ trans('home.admin') }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ url('admin/about') }}">{{ trans('home.about') }}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{ trans('home.edit_about') }}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        @if (session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title ">{{ trans('home.edit_about') }}</h6>
                        </div>
                       <form method="POST" action="{{ route('about.update') }}" enctype="multipart/form-data">
                            @csrf
                            @method('PATCH')
                        <div class="row">
                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_en">{{ trans('home.title_en') }}</label>
                                    <input type="text" class="form-control" placeholder="{{ trans('home.title_en') }}" name="title_en" value="{{ $about->title_en }}">
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_ar">{{ trans('home.title_ar') }}</label>
                                    <input type="text" class="form-control" placeholder="{{ trans('home.title_ar') }}" name="title_ar" value="{{ $about->title_ar }}">
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_en"> Title2 En</label>
                                    <input type="text" class="form-control" placeholder="Title2 En" name="title2_en" value="{{ $about->title2_en }}">
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_ar">Title2 Ar </label>
                                    <input type="text" class="form-control" placeholder="Title2 Ar" name="title2_ar" value="{{ $about->title2_ar }}">
                                </fieldset>
                            </div>


                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_en">Banner Title En</label>
                                    <input type="text" class="form-control" placeholder="Banner Title En" name="banner_title_en" value="{{ $about->banner_title_en }}">
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_ar">Banner Title Ar</label>
                                    <input type="text" class="form-control" placeholder="Banner Title Ar" name="banner_title_ar" value="{{ $about->banner_title_ar }}">
                                </fieldset>
                            </div>
                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_ar">Franchise Title En</label>
                                    <input type="text" class="form-control" placeholder="Franchise Title En" name="franchise_title_en" value="{{ $about->franchise_title_en }}">
                                </fieldset>
                            </div>
                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="title_ar">Franchise Title Ar</label>
                                    <input type="text" class="form-control" placeholder="Franchise Title AR" name="franchise_title_ar" value="{{ $about->franchise_title_ar }}">
                                </fieldset>
                            </div>


                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="short_text_en">{{ trans('home.short_text_en') }}</label>
                                    <textarea class="form-control area1" placeholder="{{ trans('home.short_text_en') }}" name="short_text_en">{!! $about->short_text_en !!}</textarea>
                                </fieldset>
                            </div>
                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="short_text_ar">{{ trans('home.short_text_ar') }}</label>
                                    <textarea class="form-control area1" placeholder="{{ trans('home.short_text_ar') }}" name="short_text_ar">{!! $about->short_text_ar !!}</textarea>
                                </fieldset>
                            </div>


                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="text_ar"> Text Title2 En</label>
                                    <textarea class="form-control area1" placeholder="Text Title2 En" name="text_title2_en">{!! $about->text_title2_en !!}</textarea>
                                </fieldset>
                            </div>

                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="text_en">Text Title2 Ar</label>
                                    <textarea class="form-control area1" placeholder="Text Title2 Ar" name="text_title2_ar">{!! $about->text_title2_ar !!}</textarea>
                                </fieldset>
                            </div>


                             <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="text_en">{{ trans('home.text_en') }}</label>
                                    <textarea class="form-control area1" placeholder="{{ trans('home.text_en') }}" name="text_en">{!! $about->text_en !!}</textarea>
                                </fieldset>
                            </div>


                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="text_ar">{{ trans('home.text_ar') }}</label>
                                    <textarea class="form-control area1" placeholder="{{ trans('home.text_ar') }}" name="text_ar">{!! $about->text_ar !!}</textarea>
                                </fieldset>
                            </div>
                             <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="text_en">Franchise Text En</label>
                                    <textarea class="form-control area1" placeholder="Franchise Text En" name="franchise_text_en">{!! $about->franchise_text_en !!}</textarea>
                                </fieldset>
                            </div>


                            <div class="form-group col-md-6 ">
                                <fieldset class="form-group">
                                    <label for="text_ar">Franchise Text AR</label>
                                    <textarea class="form-control area1" placeholder="Franchise Text AR" name="franchise_text_ar">{!! $about->franchise_text_ar !!}</textarea>
                                </fieldset>
                            </div>


                            <div class="form-group col-md-8">
                                <label>{{ trans('home.banner') }}</label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="banner">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_banner') }}</label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-4">
                                <img src="{{ $about->banner_200 }}"width="150">
                            </div>



                            <div class="form-group col-md-8">
                                <label>{{ trans('home.image') }}</label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">{{ trans('home.choose_image') }}</label>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-md-4">
                                <img src="{{ $about->image_200 }}"  width="150">
                            </div>

                            <div class="form-group col-md-8">
                                <label>franchise image</label>
                                <div class="input-group ">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> {{ trans('home.upload') }}</span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="franchise_image">
                                        <label class="custom-file-label"
                                            for="inputGroupFile01">franchise image</label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-md-4">
                                <img src="{{ $about->franchise_image }}"  width="150">
                            </div>
                            <div class="form-group col-md-3 ">
                                <fieldset class="form-group">
                                    <label for="alt_image">{{ trans('home.alt_image') }}</label>
                                    <input type="text" class="form-control" placeholder="{{ trans('home.title_en') }}" name="alt_image" value="{{ $about->alt_image }}">
                                </fieldset>
                            </div>
                            <div class="form-group col-md-3 ">
                                <fieldset class="form-group">
                                    <label for="alt_banner">{{ trans('home.alt_banner') }}</label>
                                    <input type="text" class="form-control" placeholder="{{ trans('home.alt_banner') }}" name="alt_banner" value="{{ $about->alt_banner }}">
                                </fieldset>
                            </div>
                            <div class="form-group col-md-3 ">
                                <fieldset class="form-group">
                                    <label for="alt_banner">Alt franchise image</label>
                                    <input type="text" class="form-control" placeholder="Alt franchise image" name="alt_franchise_image" value="{{ $about->alt_franchise_image }}">
                                </fieldset>
                            </div>


                            <br>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">
                                    <i class="icon-note"></i>
                                    {{ trans('home.save') }}
                                </button>
                                <a href="{{ url('/admin') }}">
                                    <button type="button" class="btn btn-danger mr-1">
                                        <i class="icon-trash"></i>
                                        {{ trans('home.cancel') }}
                                    </button>
                                </a>
                            </div>

                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
@endsection
