<?php

namespace Database\Seeders;

use App\Helpers\Media;
use App\Models\Image;
use App\Models\ProductVariant;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class VariantImageSeeder extends Seeder 
{
    public function run(): void
    {
        ProductVariant::chunk(100, function ($variants) {
            foreach ($variants as $key => $variant) {
                // Generate FRESH images for EACH variant

                for ($i = 1; $i <= 3; $i++) {
                    $attempts = 0;
                    $success = false;
                    
                    while ($attempts < 3 && !$success) {
                        
                            // Correct parameter order - width (int) before extension (string)
                            $imageFile = Media::generateFakeUploadedFile(
                                prefix: "variant-{$variant->id}-{$i}",
                                width: 800, // Example width in pixels
                                extension: 'webp'
                            );
                            
                            $imagePath = Media::uploadAndAttachImage($imageFile, 'products/variants');
                            
                            $variant->images()->create([
                                'image' => $imagePath,
                                'imageable_type' => $variant->getMorphClass(),
                                'imageable_id' => $variant->id,
                               
                            ]);
                            
                            $success = true;
                        } 
                    }
              
            }
        });
    }
}