<?php

namespace Database\Seeders;

use App\Models\Attribute;
use App\Models\Setting;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $data = [
            [
                'key' => 'app_name',
                'value' => 'e-commerce',
                'lang' => 'en',
            ],
            [
                'key' => 'app_name',
                'value' => 'متجر الكترونى',
                'lang' => 'ar',
            ],
            [
                'key' => 'top_text',
                'value' => 'Any note for users',
                'lang' => 'en',
            ],
            [
                'key' => 'top_text',
                'value' => 'لصق اشعار للمسنخدمين',
                'lang' => 'ar',
            ],
            [
                'key' => 'site_description',
                'value' => 'This is my website description.',
                'lang' => 'en',
            ],
            [
                'key' => 'site_description',
                'value' => 'هذه هي وصف موقعي.',
                'lang' => 'ar',
            ],
            [
                'key' => 'logo',
                'value' => '',
                'lang' => 'en',
            ],
            [
                'key' => 'logo',
                'value' => '',
                'lang' => 'ar',
            ],

            [
                'key' => 'footer_logo',
                'value' => '',
                'lang' => 'en',
            ],
            [
                'key' => 'footer_logo',
                'value' => '',
                'lang' => 'ar',
            ],
            [
                'key' => 'favicon',
                'value' => '',
                'lang' => 'en',
            ],
            [
                'key' => 'favicon',
                'value' => '',
                'lang' => 'ar',
            ],

            [
                'key' => 'footer_text',
                'value' => '© 2023 My Website. All rights reserved.',
                'lang' => 'en',
            ],
            [
                'key' => 'footer_text',
                'value' => '© 2025 موقعي. جميع الحقوق محفوظة.',
                'lang' => 'ar',
            ],
            [
                'key' => 'copyright',
                'value' => '© 2025 My Website. All rights reserved.',
                'lang' => 'en',
            ],
            [
                'key' => 'copyright',
                'value' => '© 2023 موقعي. جميع الحقوق محفوظة.',
                'lang' => 'ar',
            ],

            [
                'key' => 'free_amount',
                'value' => 0,
                'lang' => 'all',
            ],

            [
                'key' => 'contact_email',
                'value' => 'info@site.com',
                'lang' => 'all',
            ],
            
            [
                'key' => 'email',
                'value' => 'info@site.com',
                'lang' => 'all',
            ],
            [
                'key' => 'whatsapp',
                'value' => '+201016753421',
                'lang' => 'all',
            ],
            [
                'key' => 'twitter',
                'value' => 'https://x.com/',
                'lang' => 'all',
            ],
            [
                'key' => 'facebook',
                'value' => 'https://www.facebook.com/',
                'lang' => 'all',
            ],
            [
                'key' => 'instagram',
                'value' => 'https://www.instagram.com/',
                'lang' => 'all',
            ],
            [
                'key' => 'linkedin',
                'value' => 'https://www.linkedin.com/',
                'lang' => 'all',
            ],
            [
                'key' => 'youtube',
                'value' => 'https://www.youtube.com/',
                'lang' => 'all',
            ],
            [
                'key' => 'snapchat',
                'value' => 'https://www.snapchat.com/',
                'lang' => 'all',
            ],
            [
                'key' => 'tiktok',
                'value' => 'https://www.tiktok.com',
                'lang' => 'all',
            ],
            [
                'key' => 'pinterest',
                'value' => 'https://www.pinterest.com/',
                'lang' => 'all',
            ],
            [
                'key' => 'telegram',
                'value' => 'https://web.telegram.org',
                'lang' => 'all',
            ],
            [
                'key' => 'map',
                'value' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3452.5221691591773!2d31.330127787486845!3d30.079228310203483!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x14583e176f99d6a5%3A0x92096e6818b66f6a!2s25%20Asmaa%20Fahmi%2C%20Al%20Golf%2C%20Heliopolis%2C%20Cairo%20Governorate%204451333!5e0!3m2!1sen!2seg!4v1745182621605!5m2!1sen!2seg',
                'lang' => 'all',
            ]
        ];


        Setting::insert($data);

    }
}
