<?php

namespace Database\Seeders;

use App\Models\Country;
use App\Models\Governorate;
use Illuminate\Database\Seeder;
use Carbon\Carbon;

class GovernorateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {


        $egypt = Country::where('name_en', 'Egypt')->first();

        $egypt_governorates =   [
            // Egypt Governorates (Governorates)
            [
                'name_ar' => 'القاهرة',
                'name_en' => 'Cairo',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الجيزة',
                'name_en' => 'Giza',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الأسكندرية',
                'name_en' => 'Alexandria',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الدقهلية',
                'name_en' => 'Dakahlia',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'البحر الأحمر',
                'name_en' => 'Red Sea',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'البحيرة',
                'name_en' => 'Beheira',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الفيوم',
                'name_en' => 'Fayoum',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الغربية',
                'name_en' => 'Gharbia',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الإسماعيلية',
                'name_en' => 'Ismailia',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'المنوفية',
                'name_en' => 'Monufia',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'المنيا',
                'name_en' => 'Minya',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'القليوبية',
                'name_en' => 'Qalyubia',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الوادي الجديد',
                'name_en' => 'New Valley',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'السويس',
                'name_en' => 'Suez',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'أسوان',
                'name_en' => 'Aswan',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'أسيوط',
                'name_en' => 'Assiut',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'بني سويف',
                'name_en' => 'Beni Suef',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'بورسعيد',
                'name_en' => 'Port Said',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'دمياط',
                'name_en' => 'Damietta',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الشرقية',
                'name_en' => 'Sharqia',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'جنوب سيناء',
                'name_en' => 'South Sinai',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'كفر الشيخ',
                'name_en' => 'Kafr El Sheikh',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'مطروح',
                'name_en' => 'Matrouh',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'الأقصر',
                'name_en' => 'Luxor',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'قنا',
                'name_en' => 'Qena',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'شمال سيناء',
                'name_en' => 'North Sinai',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
            [
                'name_ar' => 'سوهاج',
                'name_en' => 'Sohag',
                'country_id' => $egypt->id,
                'shipping_fees' => rand(50, 150),
                'simple_request_shipping_fees' => rand(50, 150),
                'status' => 1,
            ],
        ];

        foreach ($egypt_governorates as $governorate) {
            Governorate::create($governorate);
        }
    }
}
