<?php

namespace Database\Seeders;

use App\Models\Area;
use App\Models\City;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {

        $areas = [
            ['name_ar' => '١٥ مايو - ١٥ مايو', 'name_en' => '15 May - 15 May', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - المروج', 'name_en' => '6 October - ElMurooj', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي المتميز', 'name_en' => '6 October - ElMotamayez District', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - حي البشاير', 'name_en' => '6 October - ElBashayer District', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 07', 'name_en' => '6 October - District 07', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - دريم لاند', 'name_en' => '6 October - Dream Land', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - طيبه جاردنز', 'name_en' => '6 October - Tiba Gardens', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - طريق الواحات', 'name_en' => '6 October - Wahat Road', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحى 02', 'name_en' => '6 October - District 02', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - القريه الذكيه', 'name_en' => '6 October - Smart Village', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحى 01', 'name_en' => '6 October - District 01', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 12', 'name_en' => '6 October - District 12', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الاحياء الجنوبيه', 'name_en' => '6 October - Southern Neighborhoods', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - حي التعاونيات 164', 'name_en' => '6 October - Taawonyat 164 Neighborhood', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - حي الورود', 'name_en' => '6 October - Hayi Alwurud', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - التوسعات الشماليه', 'name_en' => '6 October - Northern Expansions', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحزام الاخضر', 'name_en' => '6 October - Green Belt', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 04', 'name_en' => '6 October - District 04', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - واحه المهندسين', 'name_en' => '6 October - Engineers Oasis', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - المنطقه الصناعيه', 'name_en' => '6 October - Industrial Zone', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - بالم هيلز', 'name_en' => '6 October - Palm Hills', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - جامعه مصر', 'name_en' => '6 October - MSA', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - مدينه صفوه', 'name_en' => '6 October - Safwa Information Society', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - حدائق اكتوبر', 'name_en' => '6 October - October Gardens', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - كمبوند الريهام', 'name_en' => '6 October - ElReham Compound', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - مساكن عثمان', 'name_en' => '6 October - Masaken Osman', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - منطقه النوادي', 'name_en' => '6 October - Clubs Area', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - التوسعات الشرقيه', 'name_en' => '6 October - Eastern Expansions', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - ابو رواش', 'name_en' => '6 October - Abu Rawash', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - اسكان الشباب', 'name_en' => '6 October - Youth Residence', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحى 10', 'name_en' => '6 October - District 10', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحى 09', 'name_en' => '6 October - District 09', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - غرب سوميد', 'name_en' => '6 October - West Somid', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 11', 'name_en' => '6 October - District 11', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - نيو جيزه', 'name_en' => '6 October - New Giza', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 06', 'name_en' => '6 October - District 06', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 08', 'name_en' => '6 October - District 08', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - كمبوند جاردينيا', 'name_en' => '6 October - Gardenia Compound', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 03', 'name_en' => '6 October - District 03', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - هرم لايف', 'name_en' => '6 October - Haram Life', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - طريق القاهره - الاسكندريه الصحراوي', 'name_en' => '6 October - Cairo Alex Desert Road', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - الحي 05', 'name_en' => '6 October - District 05', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - كمبوند الاعلام', 'name_en' => '6 October - Media Compound', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - مصر اسكندريه الصحراوى بعد الكيلو 28', 'name_en' => '6 October - Kilo 28 Cairo - Alexandria Desert Rd', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - المنطقه السياحيه 03', 'name_en' => '6 October - Tourism 03', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - السياحيه الشماليه', 'name_en' => '6 October - North Tourism', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => '٦ اكتوبر - 6 اكتوبر', 'name_en' => '6 October - 6 October', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 54', 'name_en' => '10th of Ramadan - Neighborhood 54', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 08', 'name_en' => '10th of Ramadan - Neighborhood 08', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 30', 'name_en' => '10th of Ramadan - Neighborhood 30', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 18', 'name_en' => '10th of Ramadan - Neighborhood 18', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 58', 'name_en' => '10th of Ramadan - Neighborhood 58', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 41', 'name_en' => '10th of Ramadan - Neighborhood 41', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 16', 'name_en' => '10th of Ramadan - Neighborhood 16', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 38', 'name_en' => '10th of Ramadan - Neighborhood 38', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 28', 'name_en' => '10th of Ramadan - Neighborhood 28', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - B3', 'name_en' => '10th of Ramadan - B3', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 44', 'name_en' => '10th of Ramadan - Neighborhood 44', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - B1', 'name_en' => '10th of Ramadan - B1', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 59', 'name_en' => '10th of Ramadan - Neighborhood 59', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 06', 'name_en' => '10th of Ramadan - Neighborhood 06', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 02', 'name_en' => '10th of Ramadan - Neighborhood 02', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 37', 'name_en' => '10th of Ramadan - Neighborhood 37', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 23', 'name_en' => '10th of Ramadan - Neighborhood 23', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 40', 'name_en' => '10th of Ramadan - Neighborhood 40', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 49', 'name_en' => '10th of Ramadan - Neighborhood 49', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 46', 'name_en' => '10th of Ramadan - Neighborhood 46', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العاشر من رمضان - المجاوره 56', 'name_en' => '10th of Ramadan - Neighborhood 56', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - العتبه', 'name_en' => 'Abdeen - ElAtaba', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - الجزيره الجديده', 'name_en' => 'Abdeen - ElGazirah ElGadidah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - الدواوين', 'name_en' => 'Abdeen - ElDawawin', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - رحبه عابدين', 'name_en' => 'Abdeen - Rahbet Abdin', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - السقايين', 'name_en' => 'Abdeen - ElSaqayin', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - الساحه', 'name_en' => 'Abdeen - ElSahah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - غيط العده', 'name_en' => 'Abdeen - Ghayt ElAdah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - وسط البلد', 'name_en' => 'Abdeen - Downtown Cairo', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - باب اللوق', 'name_en' => 'Abdeen - Bab ElLouq', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - البلاقسه', 'name_en' => 'Abdeen - ElBalaqsah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - الشيخ عبد الله', 'name_en' => 'Abdeen - ElSheikh Abd Allah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - الفواله', 'name_en' => 'Abdeen - ElFawalah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'عابدين - عابدين', 'name_en' => 'Abdeen - Abdeen', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العجوزه - الحوتيه', 'name_en' => 'Agouza - ElHuwaiteyah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العجوزه - العجوزه', 'name_en' => 'Agouza - Agouza', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العجوزه - ميت عقبه', 'name_en' => 'Agouza - Mit Oqbah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العجوزه - مدينه الاوقاف - الاعلام', 'name_en' => 'Agouza - Madinet ElAwkaf', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العجوزه - المهندسين', 'name_en' => 'Agouza - Mohandesiin', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العجوزه - جزيره ميت عقبه', 'name_en' => 'Agouza - Gazirat Mit Oqbah', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العجوزه - العباس', 'name_en' => 'Agouza - ElAbbas', 'governorate_id' => 1, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now()],
            ['name_ar' => 'العامريه - مرغم', 'name_en' => 'ElAmaria - Margham', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العامريه - العجمي القبلية', 'name_en' => 'ElAmaria - ElAgamy ElQebleyah', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],[    'name_ar' => 'العامريه - زاويه عبد القادر', 'name_en' => 'ElAmaria - Zawya Abd ElQader', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العامريه - الاميريه غرب', 'name_en' => 'ElAmaria - ElAmrereyah Gharb', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العامريه - قطاع النهضه', 'name_en' => 'ElAmaria - Qetaa ElNahdah', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العريش - العريش', 'name_en' => 'ElArish - ElArish', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - الصوري', 'name_en' => 'ElAttarin - ElSouri', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - الميرغني', 'name_en' => 'ElAttarin - ElMarghani', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - المسله شرق', 'name_en' => 'ElAttarin - ElMesallah Sharq', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - العطارين غرب', 'name_en' => 'ElAttarin - ElAttarin Gharb', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - كوم الدكه غرب', 'name_en' => 'ElAttarin - Kom ElDakah Gharb', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - العطارين شرق', 'name_en' => 'ElAttarin - ElAttarin Sharq', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - محطه الرمل', 'name_en' => 'ElAttarin - Raml Station', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - العطارين', 'name_en' => 'ElAttarin - ElAttarin', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - المسله غرب وشريف باشا', 'name_en' => 'ElAttarin - ElMesallah Gharb w Sharif Basha', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - السلطان حسين', 'name_en' => 'ElAttarin - Sultan Hussein', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'العطارين - كوم الدكه شرق', 'name_en' => 'ElAttarin - Kom ElDakah Sharq', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الدايره الجمركيه - الدايره الجمركيه', 'name_en' => 'ElDayra ElGomrokeyah - ElDayra ElGomrokeyah', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الدخيله - الدخيله', 'name_en' => 'ElDekhela - ElDekhela', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الدخيله - المكس', 'name_en' => 'ElDekhela - ElMax', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الدخيله - الهانوفيل', 'name_en' => 'ElDekhela - ElHanouvel', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الدخيله - البيطاش شرق', 'name_en' => 'ElDekhela - ElBitash Sharq', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الدخيله - العجمي', 'name_en' => 'ElDekhela - ElAgamy', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الدخيله - البيطاش غرب', 'name_en' => 'ElDekhela - ElBeitash Gharb', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - السياله شرق', 'name_en' => 'ElGomrok - ElSayalah Sharq', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - الشمرللي وزاويه الاعرج', 'name_en' => 'ElGomrok - ElShamarli w Zaweyat ElAarag', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - السياله غرب', 'name_en' => 'ElGomrok - ElSayalah Gharb', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - الحلوجي', 'name_en' => 'ElGomrok - ElHalougi', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - بحري', 'name_en' => 'ElGomrok - Bahary', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - ابو شوشه', 'name_en' => 'ElGomrok - Abu Shousha', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - راس التين', 'name_en' => 'ElGomrok - Ras ElTin', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - الجمرك', 'name_en' => 'ElGomrok - ElGomrok', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - الانفوشي', 'name_en' => 'ElGomrok - ElAnfoushi', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - صفر باشا', 'name_en' => 'ElGomrok - Safar Basha', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - سوق السمك القديم', 'name_en' => 'ElGomrok - Souq ElSamak ElQadim', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),],
            ['name_ar' => 'الجمرك - البلاكتريه', 'name_en' => 'ElGomrok - ElBalqatreyah', 'governorate_id' => 2, 'shipping_fees' => 0.00, 'status' => 1, 'created_at' => now(), 'updated_at' => now(),]

        ];

        // Insert all areas into the database
        foreach ($areas as $area) {
            City::create($area);
        }
    }
}
