<?php

namespace Database\Seeders;

use App\Models\Attribute;
use App\Models\AttributeValue;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AttributeValueSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // AttributeValue::factory()->count(20)->create(); // Generate 20 attribute values
        $colorAttribute = Attribute::where('name_en', 'Color')->first();
        $chair_quantity = Attribute::where('name_en', 'Chair quantity')->first();

        if ($colorAttribute) {
            AttributeValue::insert([
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أحمر', 'value_en' => 'Red', 'code' => '#FF0000', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أزرق', 'value_en' => 'Blue', 'code' => '#0000FF', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أخضر', 'value_en' => 'Green', 'code' => '#008000', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أصفر', 'value_en' => 'Yellow', 'code' => '#FFFF00', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أسود', 'value_en' => 'Black', 'code' => '#000000', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أبيض', 'value_en' => 'White', 'code' => '#FFFFFF', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'رمادي', 'value_en' => 'Gray', 'code' => '#808080', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'برتقالي', 'value_en' => 'Orange', 'code' => '#FFA500', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'بنفسجي', 'value_en' => 'Purple', 'code' => '#800080', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'وردي', 'value_en' => 'Pink', 'code' => '#FFC0CB', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'بني', 'value_en' => 'Brown', 'code' => '#A52A2A', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'فضي', 'value_en' => 'Silver', 'code' => '#C0C0C0', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'ذهبي', 'value_en' => 'Gold', 'code' => '#FFD700', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أخضر فاتح', 'value_en' => 'Light Green', 'code' => '#90EE90', 'status' => 1],
                ['attribute_id' => $colorAttribute->id, 'value_ar' => 'أزرق فاتح', 'value_en' => 'Light Blue', 'code' => '#ADD8E6', 'status' => 1],
            ]);
        }

        if ($chair_quantity) {

            AttributeValue::insert([

                ['attribute_id' => $chair_quantity->id, 'value_ar' => 2, 'value_en' => 2,  'status' => 1],
                ['attribute_id' => $chair_quantity->id, 'value_ar' => 4, 'value_en' => 4,  'status' => 1],
                ['attribute_id' => $chair_quantity->id, 'value_ar' => 6, 'value_en' => 6,  'status' => 1],
                ['attribute_id' => $chair_quantity->id, 'value_ar' => 8, 'value_en' => 8,  'status' => 1],
                ['attribute_id' => $chair_quantity->id, 'value_ar' => 10, 'value_en' => 10,  'status' => 1],
                ['attribute_id' => $chair_quantity->id, 'value_ar' => 12, 'value_en' => 12,  'status' => 1],


            ]);
        }
    }
}
