<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payments', function (Blueprint $table) {
            // Drop the existing foreign key for order_id
            $table->dropForeign(['order_id']);

            // Make order_id nullable
            $table->unsignedBigInteger('order_id')->nullable()->change();

            // Re-add the foreign key
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');

            // Add simple_request_order_id and its foreign key
            $table->foreignId('simple_request_order_id')
                ->nullable()
                ->after('order_id');

            $table->foreign('simple_request_order_id')
                ->references('id')
                ->on('simple_request_orders')
                ->nullOnDelete();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payments', function (Blueprint $table) {

            // Drop foreign key constraints
            $table->dropForeign(['order_id']);
            $table->dropForeign(['simple_request_order_id']);

            // Change order_id back to NOT NULL
            $table->foreignId('order_id')
                ->constrained('orders')
                ->onDelete('cascade')
                ->change();

            // Drop the simple_request_order_id column
            $table->dropColumn('simple_request_order_id');
        });
    }
};
