<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->string('order_number')->unique();
            $table->foreignId('user_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('address_id')->nullable()->constrained('user_addresses');
            $table->foreignId('status_id')->nullable()->constrained('order_statuses');
            $table->decimal('shipping_fees', 10, 2)->nullable()->default(0.00);
            $table->decimal('total_amount', 10, 2)->nullable()->default(0.00);
            $table->text('note')->nullable();
            $table->boolean('admin_seen')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
