<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('categories', function (Blueprint $table) {
            $table->id();
            $table->string('name_ar');
            $table->string('name_en');
            $table->integer('order')->nullable()->default(1);
            $table->foreignId('parent_id')->nullable()->constrained('categories');
            $table->longText('text_ar')->nullable();
            $table->longText('text_en')->nullable();
            $table->string('image')->nullable();
            $table->string('icon')->nullable();
            $table->boolean('status')->default(true);
            $table->string('link_ar')->unique();
            $table->string('link_en')->unique();
            $table->string('meta_title_ar')->nullable();
            $table->string('meta_title_en')->nullable();
            $table->longText('meta_description_ar')->nullable();
            $table->longText('meta_description_en')->nullable();
            $table->boolean('index')->nullable()->default(0)->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('categories');
    }
};
